package com.interpress_project.modernshare.client.controller.actions;

import org.eclipse.jface.wizard.WizardDialog;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.client.view.wizard.Checkout2Wizard;

/**
 *@stereotype action
 */
public final class CheckOut2Action extends ActionAdaptor {
	private final ViewManager vmgr;
	private final SVNRoot root;

	/**
	 * RegisterTargetAction
	 * @param vmgr
	 */
	public CheckOut2Action(ViewManager vmgr, SVNRoot root) {
		setText("f[^Z^zbgVbgEtH_쐬(&C)");
		setToolTipText("f[^Z^烍[JPCɃzbgVbgEtH_쐬܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("chkout"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
		this.root = root;
	}

	/**
	 * run
	 */
	public void run() {
		sb.getLogger().debug("Enter CheckOut2Action()");

		LocalModelManager lmmgr = LocalModelManager.getInstance();
		if (lmmgr.isExistTagnameInRocal(root.getName())) {
			vmgr.getDialogManager().createErrorMessageDialog(root.getName() + "́AɃ[JPCɃ`FbNAEgς݂łB");
			return;
		}

		if (lmmgr.canRegisterMore() == false) {
			vmgr.getDialogManager().createErrorMessageDialog(
			  "ǗłtH_͍ő" + AppKeys.MAX_TARGETS + "ƂȂ܂BȏtH_`FbNAEg邱Ƃ͂ł܂B");
			return;
		}

		TaskManager taskmgr = TaskManager.getInstance();
		try {
			taskmgr.stop();

			Checkout2Wizard checkout2Wizard = new Checkout2Wizard(root);
			WizardDialog dlg = new WizardDialog(vmgr.getShell(), checkout2Wizard);
			dlg.setPageSize(500, 190);
			dlg.open();
		}
		finally {
			taskmgr.start();
		}
	}

}
