package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class ActivateTargetAction extends ActionAdaptor {
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
	private ViewManager vmgr;
	private LocalRoot item;

	/**
	 * ActivateTargetAction
	 * @param vmgr
	 * @param path
	 */
	public ActivateTargetAction(ViewManager vmgr, LocalRoot item) {
		setText("ĎJn(&S)");
		setToolTipText("ΏۂƂȂzbgVbgtH_ɑ΂鎩ĎJn܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("connected"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
		this.item = item;
	}

	/**
	 * setActive
	 * @param path
	 */
	private void setActive(String path) {
		cmdmgr.addCommand(factory.createActiveTargetCommand(path, RootStatus.active));
	}

	/**
	 * run
	 */
	public void run() {
		int mode = -1;

		TaskManager taskmgr = TaskManager.getInstance();
		try {
			taskmgr.stop();

			boolean bAnswer = vmgr.getDialogManager().createYesNoMessageDialog("Ď̊JnmF",
			  "zbgVbgtH_" + item.getAbsolutePath() + "ɑ΂鎩ĎJn܂B");
			if (bAnswer == false) {
				return;
			}

			/**
			 * ^[QbgtH_ROł΃_CAO͕\ɁAHost2PCsB
			 */
			if (item.getPc2host()) {
				mode = vmgr.getDialogManager().createSyncModeDialog();
				if (mode == -1) { // Selected CANCEL
					return;
				}
			}
			else {
				mode = 1; // m[hHost2PcłΓRemote->PĈ݁B_CAOsvB				
			}

			guiEventSource.fireEvent(new GUIEvent(this, item.getAbsolutePath() + "ւ̎ĎJn܂...", GUIEventType.START));

			switch (mode) {
				default: {
					return;
				}
				case 0: {
					cmdmgr.addCommand(factory.createSyncRemoteWithLocalCommand(item));
					break;
				}
				case 1: {
					cmdmgr.addCommand(factory.createSyncLocalWithRemoteCommand(item));
					break;
				}
			}
			setActive(item.getAbsolutePath());

			logEventSource.fireEvent(new LogEvent(this, "zbgVbgtH_" + item.getAbsolutePath() + "ɑ΂鎩ĎJn܂B",
			  LogEventType.INFO));
		}
		finally {
			guiEventSource.fireEvent(new GUIEvent(this, "zbgVbgtH_" + item.getAbsolutePath() + "̎ĎJn܂B",
			  GUIEventType.FINISH));
			taskmgr.start();
		}
	}
}
