package com.interpress_project.modernshare.client.controller.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

import com.interpress_project.modernshare.client.events.GUIEventSource;
import com.interpress_project.modernshare.client.events.LocalViewEventSource;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.RemoteViewEventSource;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public abstract class ActionAdaptor extends Action implements ISelectionChangedListener, IDoubleClickListener,
    SelectionListener {
	protected final SystemBase sb = SystemBase.getInstance();
	protected final LocalViewEventSource localViewEventSource = LocalViewEventSource.getInstance();
	protected final RemoteViewEventSource remoteViewEventSource = RemoteViewEventSource.getInstance();
	protected final LogEventSource logEventSource = LogEventSource.getInstance();
	protected final GUIEventSource guiEventSource = GUIEventSource.getInstance();

	/**
	 * selectionChanged
	 */
	public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
	}

	/**
	 * doubleClick
	 */
	public void doubleClick(DoubleClickEvent doubleClickEvent) {
	}

	/**
	 * widgetSelected
	 */
	public void widgetSelected(SelectionEvent selectionEvent) {
	}

	/**
	 * widgetDefaultSelected
	 */
	public void widgetDefaultSelected(SelectionEvent selectionEvent) {
	}
}
