package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.delegate.AdminSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.delegate.secureguard.SVNproxy;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 * @stereotype interface
 */
public abstract class IUserAdmin {
	protected final SystemBase sb = SystemBase.getInstance();
	protected final PropertyManager propmgr = PropertyManager.getInstance();
	protected final ORBManager orbmgr = ORBManager.getInstance();
	protected final AdminSVNManager svnmgr = AdminSVNManager.getInstance();
	protected SVNproxy proxy = null;
	protected String rootPassword, newAccount, newPassword;

	/**
	 * IUserAdmin
	 * @param args
	 */
	public IUserAdmin(String[] args) {
		parseOptions(args);

		int sgport = propmgr.getSecureGuardPort();
		++sgport;
		propmgr.setSecureGuardPort(sgport);
	}

	/**
	 * exec
	 */
	protected void exec() {
		proxy = new SVNproxy();
		proxy.start();

		/**
		 * Main process.
		 */
		try {
			run();
		}
		finally {
			proxy.dispose();
		}
	}

	/**
	 * setRootPassword
	 * @param pass
	 */
	protected void setRootPassword(String pass) {
		this.rootPassword = pass;
	}

	/**
	 * getRootPassword
	 * @return
	 */
	protected String getRootPassword() {
		return rootPassword;
	}

	/**
	 * setNewAccount
	 * @param account
	 */
	protected void setNewAccount(String account) {
		this.newAccount = account;
	}

	/**
	 * getNewAccount
	 * @return
	 */
	protected String getNewAccount() {
		return this.newAccount;
	}

	/**
	 * setNewPassword
	 * @param password
	 */
	protected void setNewPassword(String password) {
		this.newPassword = password;
	}

	/**
	 * getNewPassword
	 * @return
	 */
	protected String getNewPassword() {
		return this.newPassword;
	}

	/**
	 * setAdminHost
	 * @param host
	 */
	protected void setAdminHost(String host) {
		propmgr.setValue(AppKeys.ADMIN_HOST, host);
	}

	/**
	 * getAdminHost
	 * @return
	 */
	protected String getAdminHost() {
		return propmgr.getAdminHost();
	}

	/**
	 * setAdminPort
	 * @param port
	 */
	protected void setAdminPort(int port) {
		propmgr.setValue(AppKeys.ADMIN_PORT, port);
	}

	/**
	 * getAdminPort
	 * @return
	 */
	protected int getAdminPort() {
		return propmgr.getAdminPort();
	}

	/**
	 * run
	 */
	protected abstract void run();

	/**
	 * parseOptions
	 * @param args
	 */
	protected abstract void parseOptions(String[] args);
}
