package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.AppKeys;

/**
 * @stereotype Main
 */
public class HotBackup extends IUserAdmin {
	/**
	 * Useradd
	 * @param args
	 */
	public HotBackup(String[] args) {
		super(args);

		sb.setLoggerInfo(AppKeys.ProgramName, AppKeys.LogFilename);
	}

	/**
	 * parseOptions
	 * @param args
	 */
	protected void parseOptions(String[] args) {
		if (args.length == 0) {
			usage();
			System.exit(-1);
		}
		for (int i = 0; i < args.length; i++) {
			if ("-rootpass".equalsIgnoreCase(args[i])) {
				setRootPassword(args[++i]);
			}
			else if ("-host".equalsIgnoreCase(args[i])) {
				setAdminHost(args[++i]);
			}
			else if ("-port".equalsIgnoreCase(args[i])) {
				setAdminPort(new Integer(args[++i]).intValue());
			}
		}
		if (getRootPassword().length() == 0 || this.getAdminHost().length() == 0) {
			usage();
			System.exit(-1);
		}
	}

	/**
	 * usage
	 */
	private void usage() {
		System.out.println("Usage: hotbackup -rootpass <password> -host <targethost> -port <portnum>");
		System.out.println("HotShot utility hotbackup makes a hot copy of the HotShot repository.");
		System.out.println("\t-rootpass <pass>\t: Password for root account.");
		System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
		System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
	}

	/**
	 * run
	 * The ORB/SVN connections carried out in the upper layer.
	 */
	@Override
	protected void run() {
		String path = null;
		try {
			sb.getLogger().info("f[^Z^̃|WgEobNAbvJn܂B");
			sb.getLogger().info("΂炭҂...");

			path = orbmgr.backup("root", getRootPassword());
		}
		catch (Exception ex) {
			sb.getLogger().fatal("obNAbvs܂B", ex);
			return;
		}
		sb.getLogger().info("f[^Z^̃|WgEobNAbv܂B");
		sb.getLogger().info("f[^Z^̃obNAbv̈" + path + "ɃzbgVbgi[܂B");
	}

	/**
	 * main
	 * @param args
	 */
	public static void main(String[] args) {
		IUserAdmin admin = new HotBackup(args);
		admin.exec();
	}
}
