/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNKeywords;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class AbstractClientAdapter
implements ISVNClientAdapter {
    public void setKeywords(File path, SVNKeywords keywords, boolean recurse) throws SVNClientException {
        this.propertySet(path, "svn:keywords", keywords.toString(), recurse);
    }

    public SVNKeywords addKeywords(File path, SVNKeywords keywords) throws SVNClientException {
        SVNKeywords currentKeywords = this.getKeywords(path);
        if (keywords.isHeadUrl()) {
            currentKeywords.setHeadUrl(true);
        }
        if (keywords.isId()) {
            currentKeywords.setId(true);
        }
        if (keywords.isLastChangedBy()) {
            currentKeywords.setLastChangedBy(true);
        }
        if (keywords.isLastChangedDate()) {
            currentKeywords.setLastChangedBy(true);
        }
        if (keywords.isLastChangedRevision()) {
            currentKeywords.setLastChangedRevision(true);
        }
        this.setKeywords(path, currentKeywords, false);
        return currentKeywords;
    }

    public SVNKeywords removeKeywords(File path, SVNKeywords keywords) throws SVNClientException {
        SVNKeywords currentKeywords = this.getKeywords(path);
        if (keywords.isHeadUrl()) {
            currentKeywords.setHeadUrl(false);
        }
        if (keywords.isId()) {
            currentKeywords.setId(false);
        }
        if (keywords.isLastChangedBy()) {
            currentKeywords.setLastChangedBy(false);
        }
        if (keywords.isLastChangedDate()) {
            currentKeywords.setLastChangedBy(false);
        }
        if (keywords.isLastChangedRevision()) {
            currentKeywords.setLastChangedRevision(false);
        }
        this.setKeywords(path, currentKeywords, false);
        return currentKeywords;
    }

    public List getIgnoredPatterns(File path) throws SVNClientException {
        if (!path.isDirectory()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        ISVNProperty pd = this.propertyGet(path, "svn:ignore");
        if (pd == null) {
            return list;
        }
        String patterns = pd.getValue();
        StringTokenizer st = new StringTokenizer(patterns, "\n\r");
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (entry == null || entry.length() <= 0) continue;
            list.add(entry);
        }
        return list;
    }

    public ISVNLogMessage[] getLogMessages(File arg0, SVNRevision arg1, SVNRevision arg2) throws SVNClientException {
        return this.getLogMessages(arg0, arg1, arg2, true);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2) throws SVNClientException {
        return this.getLogMessages(arg0, arg1, arg2, true);
    }

    public void setIgnoredPatterns(File path, List patterns) throws SVNClientException {
        if (!path.isDirectory()) {
            return;
        }
        String separator = System.getProperty("line.separator");
        StringBuffer value = new StringBuffer();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            String pattern = (String)it.next();
            value.append(pattern + separator);
        }
        this.propertySet(path, "svn:ignore", value.toString(), false);
    }

    public void addToIgnoredPatterns(File path, String pattern) throws SVNClientException {
        List patterns = this.getIgnoredPatterns(path);
        if (patterns == null) {
            return;
        }
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(pattern)) continue;
            return;
        }
        patterns.add(pattern);
        this.setIgnoredPatterns(path, patterns);
    }

    public SVNKeywords getKeywords(File path) throws SVNClientException {
        ISVNProperty prop = this.propertyGet(path, "svn:keywords");
        if (prop == null) {
            return new SVNKeywords();
        }
        String value = prop.getValue();
        return new SVNKeywords(value);
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
    }

    public boolean statusReturnsRemoteInfo() {
        return false;
    }

    public long[] commitAcrossWC(File[] paths, String message, boolean recurse, boolean keepLocks, boolean Atomic) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    protected void notImplementedYet() throws SVNClientException {
        throw new SVNClientException("Not implemented yet");
    }

    public boolean canCommitAcrossWC() {
        return false;
    }

    public void mkdir(SVNUrl url, boolean makeParents, String message) throws SVNClientException {
        SVNUrl parent;
        if (makeParents && (parent = url.getParent()) != null) {
            ISVNInfo info = null;
            try {
                info = this.getInfo(parent);
            }
            catch (SVNClientException e) {
                // empty catch block
            }
            if (info == null) {
                this.mkdir(parent, makeParents, message);
            }
        }
        this.mkdir(url, message);
    }

    public static boolean isOsWindows() {
        try {
            return System.getProperty("os.name").startsWith("Windows");
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public ISVNInfo getInfo(SVNUrl url) throws SVNClientException {
        return this.getInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, dryRun, false);
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, false, false);
    }

    public ISVNProperty propertyGet(SVNUrl url, String propertyName) throws SVNClientException {
        return this.propertyGet(url, SVNRevision.HEAD, SVNRevision.HEAD, propertyName);
    }
}

