/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleHost
extends AbstractBundle {
    private BundleLoaderProxy proxy;
    protected BundleContextImpl context = null;
    protected BundleFragment[] fragments = null;

    public BundleHost(BundleData bundledata, Framework framework) throws BundleException {
        super(bundledata, framework);
    }

    protected void load() {
        SecurityManager sm;
        if (Debug.DEBUG_GENERAL) {
            if ((this.state & 2) == 0) {
                Debug.println("Bundle.load called when state != INSTALLED: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            if (this.proxy != null) {
                Debug.println("Bundle.load called when proxy != null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
        }
        if (this.framework.isActive() && (sm = System.getSecurityManager()) != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        this.proxy = null;
    }

    protected boolean reload(AbstractBundle newBundle) {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy = this.getLoaderProxy();
                exporting = curProxy.inUse();
                if (exporting) {
                    curProxy.getBundleLoader().createClassLoader();
                } else {
                    BundleHost.closeBundleLoader(this.proxy);
                }
                this.state = 2;
                this.proxy = null;
                this.fragments = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        if (this.framework.isActive() && System.getSecurityManager() != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        return exporting;
    }

    protected void refresh() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.reload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            BundleHost.closeBundleLoader(this.proxy);
            this.proxy = null;
            this.fragments = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive() && this.state == 4) {
            BundleLoaderProxy curProxy = this.getLoaderProxy();
            exporting = curProxy.inUse();
            if (exporting) {
                curProxy.getBundleLoader().createClassLoader();
            } else {
                BundleHost.closeBundleLoader(this.proxy);
            }
            this.state = 2;
            this.proxy = null;
            this.fragments = null;
            this.domain = null;
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    private BundleLoader checkLoader() {
        BundleLoader loader;
        this.checkValid();
        if (!this.isResolved() && !this.framework.packageAdmin.resolveBundles(new Bundle[]{this})) {
            return null;
        }
        if (Debug.DEBUG_GENERAL && (this.state & 0x3C) == 0) {
            Debug.println("Bundle.checkLoader() called when state != STARTING | ACTIVE | STOPPING | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if ((loader = this.getBundleLoader()) == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.checkLoader() called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return loader;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        BundleLoader loader;
        if (checkPermission) {
            try {
                this.framework.checkAdminPermission(this, "class");
            }
            catch (SecurityException securityException) {
                throw new ClassNotFoundException();
            }
        }
        if ((loader = this.checkLoader()) == null) {
            throw new ClassNotFoundException(NLS.bind(Msg.BUNDLE_CNFE_NOT_RESOLVED, this.getBundleData().getLocation(), name));
        }
        return loader.loadClass(name);
    }

    public URL getResource(String name) {
        BundleLoader loader = null;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        loader = this.checkLoader();
        if (loader == null) {
            return null;
        }
        return loader.getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        BundleLoader loader = null;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        loader = this.checkLoader();
        if (loader == null) {
            return null;
        }
        Enumeration result = loader.getResources(name);
        if (result.hasMoreElements()) {
            return result;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected void startWorker(boolean persistent) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 477->481)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected BundleContextImpl createContext() {
        return new BundleContextImpl(this);
    }

    protected BundleContextImpl getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopWorker(boolean persistent) throws BundleException {
        Object var2_2;
        if (persistent) {
            this.setStatus(1, false);
        }
        if (!this.framework.active) return;
        if ((this.state & 0x16) != 0) {
            return;
        }
        BundleWatcher bundleStats = this.framework.adaptor.getBundleWatcher();
        if (bundleStats != null) {
            bundleStats.watchBundle(this, 16);
        }
        this.state = 16;
        this.framework.publishBundleEvent(256, this);
        try {
            this.context.stop();
        }
        catch (Throwable throwable) {
            var2_2 = null;
            this.context.close();
            this.context = null;
            this.checkValid();
            this.state = 4;
            if (Debug.DEBUG_GENERAL) {
                Debug.println("->stopped " + this);
            }
            this.framework.publishBundleEvent(4, this);
            BundleWatcher bundleStats2 = this.framework.adaptor.getBundleWatcher();
            if (bundleStats2 == null) throw throwable;
            bundleStats2.watchBundle(this, 32);
            throw throwable;
        }
        {
            var2_2 = null;
            this.context.close();
            this.context = null;
        }
        this.checkValid();
        this.state = 4;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->stopped " + this);
        }
        this.framework.publishBundleEvent(4, this);
        BundleWatcher bundleStats2 = this.framework.adaptor.getBundleWatcher();
        if (bundleStats2 == null) return;
        bundleStats2.watchBundle(this, 32);
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getServicesInUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle[] getFragments() {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            block4: {
                if (this.fragments != null) break block4;
                return null;
            }
            Bundle[] result = new Bundle[this.fragments.length];
            System.arraycopy(this.fragments, 0, result, 0, result.length);
            return result;
        }
    }

    protected void attachFragment(BundleFragment fragment) throws BundleException {
        BundleLoader loader = this.getLoaderProxy().getBasicBundleLoader();
        if (loader != null) {
            loader.attachFragment(fragment);
        }
        if (this.fragments == null) {
            this.fragments = new BundleFragment[]{fragment};
        } else {
            boolean inserted = false;
            BundleFragment[] newFragments = new BundleFragment[this.fragments.length + 1];
            int i = 0;
            while (i < this.fragments.length) {
                if (fragment == this.fragments[i]) {
                    return;
                }
                if (!inserted && fragment.getBundleId() < this.fragments[i].getBundleId()) {
                    if (loader != null) {
                        throw new BundleException(NLS.bind(Msg.BUNDLE_LOADER_ATTACHMENT_ERROR, this.fragments[i].getSymbolicName(), this.getSymbolicName()));
                    }
                    newFragments[i] = fragment;
                    inserted = true;
                }
                newFragments[inserted ? i + 1 : i] = this.fragments[i];
                ++i;
            }
            if (!inserted) {
                newFragments[newFragments.length - 1] = fragment;
            }
            this.fragments = newFragments;
        }
    }

    protected BundleLoader getBundleLoader() {
        return this.getLoaderProxy().getBundleLoader();
    }

    protected synchronized BundleLoaderProxy getLoaderProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        BundleDescription bundleDescription = this.getBundleDescription();
        this.proxy = new BundleLoaderProxy(this, bundleDescription);
        bundleDescription.setUserObject(this.proxy);
        return this.proxy;
    }

    static void closeBundleLoader(BundleLoaderProxy proxy) {
        if (proxy == null) {
            return;
        }
        BundleLoader loader = proxy.getBasicBundleLoader();
        if (loader != null) {
            loader.close();
        }
        proxy.setStale();
        BundleDescription description = proxy.getBundleDescription();
        description.setUserObject(null);
    }
}

