/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.optimize.KeepMarker;

public class SingleImplementationMarker
implements ClassFileVisitor {
    private static final boolean DEBUG = false;
    private boolean allowAccessModification;
    private ClassFileVisitor extraClassFileVisitor;

    public SingleImplementationMarker(boolean bl) {
        this(bl, null);
    }

    public SingleImplementationMarker(boolean bl, ClassFileVisitor classFileVisitor) {
        this.allowAccessModification = bl;
        this.extraClassFileVisitor = classFileVisitor;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if ((programClassFile.getAccessFlags() & 0x200) == 0 || KeepMarker.isKept(programClassFile)) {
            return;
        }
        ClassFile[] classFileArray = programClassFile.subClasses;
        if (classFileArray == null || classFileArray.length != 1) {
            return;
        }
        ClassFile classFile = classFileArray[0];
        int n = classFile.getAccessFlags();
        if ((n & 0x200) != 0) {
            classFile.accept(this);
            classFile = SingleImplementationMarker.singleImplementation(classFile);
            if (classFile == null) {
                return;
            }
            n = classFile.getAccessFlags();
        }
        for (int i = 0; i < programClassFile.u2methodsCount; ++i) {
            ProgramMethodInfo programMethodInfo = programClassFile.methods[i];
            if ((programMethodInfo.getAccessFlags() & 8) != 0 || classFile.findMethod(programMethodInfo.getName(programClassFile), programMethodInfo.getDescriptor(programClassFile)) != null) continue;
            return;
        }
        if (AccessUtil.accessLevel(n) < AccessUtil.accessLevel(programClassFile.getAccessFlags())) {
            if (this.allowAccessModification) {
                ((ProgramClassFile)classFile).u2accessFlags = AccessUtil.replaceAccessFlags(n, programClassFile.getAccessFlags());
            } else {
                return;
            }
        }
        SingleImplementationMarker.markSingleImplementation(programClassFile, classFile);
        if (this.extraClassFileVisitor != null) {
            classFile.accept(this.extraClassFileVisitor);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public static void markSingleImplementation(VisitorAccepter visitorAccepter, ClassFile classFile) {
        visitorAccepter.setVisitorInfo(classFile);
    }

    public static ClassFile singleImplementation(VisitorAccepter visitorAccepter) {
        return visitorAccepter != null && visitorAccepter.getVisitorInfo() instanceof ClassFile ? (ClassFile)visitorAccepter.getVisitorInfo() : null;
    }
}

