/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMemberInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.visitor.AllMemberInfoVisitor;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoAccessFilter;
import proguard.classfile.visitor.MemberInfoVisitor;

public class MethodInfoLinker
implements ClassFileVisitor,
MemberInfoVisitor {
    private final Map memberInfoMap = new HashMap();

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.visitClassFile(programClassFile);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        this.visitClassFile(libraryClassFile);
    }

    private void visitClassFile(ClassFile classFile) {
        classFile.hierarchyAccept(true, true, true, false, new AllMemberInfoVisitor(new MemberInfoAccessFilter(0, 2, this)));
        this.memberInfoMap.clear();
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        this.visitMemberInfo(libraryClassFile, libraryFieldInfo);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.visitMemberInfo(libraryClassFile, libraryMethodInfo);
    }

    private void visitMemberInfo(ClassFile classFile, MemberInfo memberInfo) {
        String string = memberInfo.getName(classFile);
        String string2 = memberInfo.getDescriptor(classFile);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        MemberInfo memberInfo2 = MethodInfoLinker.lastMemberInfo(memberInfo);
        String string3 = string + ' ' + string2;
        MemberInfo memberInfo3 = (MemberInfo)this.memberInfoMap.get(string3);
        if (memberInfo3 == null) {
            this.memberInfoMap.put(string3, memberInfo2);
        } else {
            MemberInfo memberInfo4 = MethodInfoLinker.lastMemberInfo(memberInfo3);
            if (!memberInfo2.equals(memberInfo4)) {
                if (memberInfo4 instanceof LibraryMemberInfo) {
                    memberInfo2.setVisitorInfo(memberInfo4);
                } else {
                    memberInfo4.setVisitorInfo(memberInfo2);
                }
            }
        }
    }

    public static MemberInfo lastMemberInfo(MemberInfo memberInfo) {
        MemberInfo memberInfo2 = memberInfo;
        while (memberInfo2.getVisitorInfo() != null && memberInfo2.getVisitorInfo() instanceof MemberInfo) {
            memberInfo2 = (MemberInfo)memberInfo2.getVisitorInfo();
        }
        return memberInfo2;
    }

    public static VisitorAccepter lastVisitorAccepter(VisitorAccepter visitorAccepter) {
        VisitorAccepter visitorAccepter2 = visitorAccepter;
        while (visitorAccepter2.getVisitorInfo() != null && visitorAccepter2.getVisitorInfo() instanceof VisitorAccepter) {
            visitorAccepter2 = (VisitorAccepter)visitorAccepter2.getVisitorInfo();
        }
        return visitorAccepter2;
    }
}

