/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.ClassPool;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;

public class ClassFileHierarchyInitializer
implements ClassFileVisitor,
CpInfoVisitor {
    private static final Object INITIALIZED = new Object();
    private ClassPool programClassPool;
    private ClassPool libraryClassPool;
    private WarningPrinter warningPrinter;

    public ClassFileHierarchyInitializer(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.warningPrinter = warningPrinter;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if (!ClassFileHierarchyInitializer.isInitialized(programClassFile)) {
            ClassFileHierarchyInitializer.markAsInitialized(programClassFile);
            if (programClassFile.u2superClass != 0) {
                programClassFile.constantPoolEntryAccept(programClassFile.u2superClass, this);
            }
            if (programClassFile.u2superClass != 0) {
                this.addSubclass(programClassFile, programClassFile.getSuperClass(), programClassFile.getSuperName());
            }
            for (int i = 0; i < programClassFile.u2interfacesCount; ++i) {
                programClassFile.constantPoolEntryAccept(programClassFile.u2interfaces[i], this);
                this.addSubclass(programClassFile, programClassFile.getInterface(i), programClassFile.getInterfaceName(i));
            }
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        if (!ClassFileHierarchyInitializer.isInitialized(libraryClassFile)) {
            String[] stringArray;
            ClassFileHierarchyInitializer.markAsInitialized(libraryClassFile);
            String string = libraryClassFile.superClassName;
            if (string != null) {
                stringArray = this.findAndInitializeClass(string);
                this.addSubclass(libraryClassFile, (ClassFile)stringArray, string);
                libraryClassFile.superClass = stringArray;
            }
            if (libraryClassFile.interfaceNames != null) {
                stringArray = libraryClassFile.interfaceNames;
                ClassFile[] classFileArray = new ClassFile[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    ClassFile classFile = this.findAndInitializeClass(string2);
                    this.addSubclass(libraryClassFile, classFile, string2);
                    classFileArray[i] = classFile;
                }
                libraryClassFile.interfaceClasses = classFileArray;
            }
            libraryClassFile.superClassName = null;
            libraryClassFile.interfaceNames = null;
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        classCpInfo.referencedClassFile = this.findAndInitializeClass(classCpInfo.getName(classFile));
    }

    private ClassFile findAndInitializeClass(String string) {
        ClassFile classFile = this.findClass(string);
        if (classFile != null) {
            classFile.accept(this);
        }
        return classFile;
    }

    private ClassFile findClass(String string) {
        ClassFile classFile = this.programClassPool.getClass(string);
        if (classFile == null) {
            classFile = this.libraryClassPool.getClass(string);
        }
        return classFile;
    }

    private static void markAsInitialized(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(INITIALIZED);
    }

    private static boolean isInitialized(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == INITIALIZED;
    }

    private void addSubclass(ClassFile classFile, ClassFile classFile2, String string) {
        if (classFile2 != null) {
            classFile2.addSubClass(classFile);
        } else if (this.warningPrinter != null) {
            this.warningPrinter.print("Warning: " + ClassUtil.externalClassName(classFile.getName()) + ": can't find superclass or interface " + ClassUtil.externalClassName(string));
        }
    }
}

