/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.omg.CORBA.TIMEOUT;

public class PortRangeSocketFactory
extends AbstractSocketFactory {
    public static final String MIN_PROP = "jacorb.net.socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.socket_factory.port.max";
    private int portMin;
    private int portMax;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.portMin = this.getPortProperty(configuration, MIN_PROP);
        this.portMax = this.getPortProperty(configuration, MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                Socket socket = new Socket(string, n, inetAddress, i);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("PortRangeSocketFactory: Created server socket at :" + i);
                }
                return socket;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + string + ":" + n);
        }
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public boolean isSSL(Socket socket) {
        return false;
    }

    private int getPortProperty(Configuration configuration, String string) throws ConfigurationException {
        int n = configuration.getAttributeAsInteger(string);
        if (n < 0) {
            n += 65536;
        }
        if (n <= 0 || n > 65535) {
            throw new ConfigurationException("PortRangeFactory: " + string + " invalid port number");
        }
        return n;
    }

    public Socket doCreateSocket(String string, int n, int n2) throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        boolean bl = n2 != 0;
        long l = bl ? System.currentTimeMillis() + (long)n2 : Long.MAX_VALUE;
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                Socket socket = new Socket();
                socket.bind(new InetSocketAddress(inetAddress, i));
                socket.connect(new InetSocketAddress(string, n), n2);
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("PortRangeSocketFactory: Created socket between " + inetAddress.getHostAddress() + ":" + i + " and " + string + ":" + n);
                }
                return socket;
            }
            catch (IOException iOException) {
                if (!bl || System.currentTimeMillis() <= l) continue;
                throw new TIMEOUT("couldn't open socket within " + n2 + ". Last exception details: " + iOException.toString());
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + string + ":" + n);
        }
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }
}

