/* ------------------------------------------------------------------------ */
/* Hyper Operating System V4 Advance                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */



				.global	__kernel_dis_int		/* 割り込み禁止 */
				.global	__kernel_ena_int		/* 割り込み許可 */
				.global	__kernel_wai_int		/* 割り込み待ち */
				.global	__kernel_cre_ctx		/* 実行コンテキストの作成 */
				.global	__kernel_swi_ctx		/* 実行コンテキストの切替 */
				.global	__kernel_sta_ctx		/* 実行コンテキストの開始 */
				.global	__kernel_rst_ctx		/* 実行コンテキストのリスタート */
				.global	__kernel_sh_imsk		/* 割り込みマスクの値 */


				.text


/************************************************
  割り込み禁止
  void _kernel_dis_int(void)
************************************************/
				.align	2
__kernel_dis_int:
				stc		sr, r0
				or		#0xf0, r0				/* 全割り込みマスク */
				rts
				ldc		r0, sr



/************************************************
  割り込み許可
  void _kernel_ena_int(void)
************************************************/
				.align	2
__kernel_ena_int:
				mov.l	addr_sh_imsk, r2
				stc		sr, r0
				mov.l	@r2, r1
				or		#0xf0, r0
				xor		#0xf0, r0
				or		r1, r0					/* 割り込みマスクの値を設定 */
				rts
				ldc		r0, sr

				.align	2
addr_sh_imsk:
				.long	__kernel_sh_imsk		/* 割り込みマスク */


/************************************************
 割り込み待ち
 void _kernel_wai_int(void)
************************************************/
				.align	2
__kernel_wai_int:
		;		sleep
				bra		__kernel_wai_int
				nop


/************************************************
  実行コンテキストの作成
  _kernel_cre_ctx(
		_KERNEL_T_CTXCB *pk_ctxcb,		作成するコンテキスト [r4]
		VP              isp,			初期スタックポインタ [r5]
		FP              entry,			実行アドレス         [r6]
		VP_INT          par1,			実行時パラメータ1    [r7]
		VP_INT          par2)			実行時パラメータ2    [@(4, r15)]
************************************************/
				.align 2
__kernel_cre_ctx:
				add 	#-40, r5				/* スタックに領域を確保 */
				mov.l	r6, @(36, r5)			/* 実行アドレスを      r8 の領域に設定 */
				mov.l	r7, @(32, r5)			/* 実行時パラメータ1を r9 の領域に設定 */
				mov.l	@(0, r15), r0
				mov.l	r0, @(28, r5)			/* 実行時パラメータ2を r10 の領域に設定 */
				mov.l	addr_ctx_entry, r0
				mov.l	r0, @(0, r5)			/* 実行エントリポイントを pr の領域に設定 */
				rts
				mov.l	r5, @(0, r4) 			/* スタックポインタを保存(遅延スロット) */

				.align 2
addr_ctx_entry:
				.long	ctx_entry

/************************************************
  実行コンテキストエントリーアドレス
************************************************/
ctx_entry:
				mov		r9, r4					/* 実行時パラメータ1を設定 */
				jmp		@r8						/* 実行開始アドレスに分岐 */
				mov		r10, r5					/* 実行時パラメータ2を設定(遅延スロット) */



/************************************************
 実行コンテキストの切替
 void _kernel_swi_ctx(
		_KERNEL_T_CTXCB *pk_ctxcb_nxt,	切り替え先のコンテキスト [r4]
		_KERNEL_T_CTXCB *pk_ctxcb_now)	現在のコンテキスト       [r5]
************************************************/
				.align 2
__kernel_swi_ctx:
				mov.l	r8, @-r15		/* 8-r14,prを退避 */
				mov.l	r9, @-r15
				mov.l	r10, @-r15
				mov.l	r11, @-r15
				mov.l	r12, @-r15
				mov.l	r13, @-r15
				mov.l	r14, @-r15
				sts.l	macl, @-r15
				sts.l	mach, @-r15
				sts.l	pr, @-r15
				mov.l	r15, @(0, r5)	/* スタックポインタ保存 */
		/* ---- このまま _kernel_sta_ctx に続ける ---- */

/************************************************
 実行コンテキストの開始
 void _kernel_sta_ctx(
		_KERNEL_T_CTXCB *pk_ctxcb)		開始するコンテキスト [r4]
************************************************/
__kernel_sta_ctx:
				mov.l	@(0, r4), r15	/* スタックポインタ復帰 */
				lds.l	@r15+, pr		/* r8-r14,prを復帰 */
				lds.l	@r15+, mach
				lds.l	@r15+, macl
				mov.l	@r15+, r14
				mov.l	@r15+, r13
				mov.l	@r15+, r12
				mov.l	@r15+, r11
				mov.l	@r15+, r10
				mov.l	@r15+, r9
				rts
				mov.l	@r15+, r8


/************************************************
 実行コンテキストのリスタート
 void _kernel_rst_ctx(
		VP_INT par1,							実行時パラメータ1    [r4]
		VP_INT par2,							実行時パラメータ2    [r5]
		VP     isp,								初期スタックポインタ [r6]
		FP     entry)							実行アドレス         [r7]
************************************************/
				.align	2
__kernel_rst_ctx:
				jmp		@r7						/* 実行アドレスに分岐 */
				mov		r6, r15					/* スタックポインタリセット(遅延スロット) */


				.comm	__kernel_sh_imsk,4,4


				.end

/* end of file */
