/**
 *  Hyper Operating System V4 Advance
 *
 * Copyright (C) 1998-2011 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


				.syntax unified

				.text
				.align	2


/************************************************
  実行コンテキストの作成
  void _kernel_cre_ctx(
			_KERNEL_T_CTXCB *pk_ctxcb,	r0   :作成するコンテキスト
			VP             isp,			r1   :スタックポインタ
			FP             entry,		r2   :実行アドレス
			VP_INT         par1,		r3   :実行時パラメータ
			VP_INT         par2)		sp[0]:実行時パラメータ
 ************************************************/
				.global	_kernel_cre_ctx
				.thumb
				.thumb_func
				.type	_kernel_cre_ctx, %function
_kernel_cre_ctx:
				sub		r1, #40						/* スタックを確保 */
				str		r2, [r1, #4]				/* r4 部分にentryを設定 */
				str		r3, [r1, #8]				/* r5 部分にpar1を設定 */
				ldr		r2, [sp, #0]				/* par2を取り出し */
				str		r2, [r1, #12]				/* r6 部分にpar2を設定 */
				movw	r2, #:lower16:ctx_entry
				movt	r2, #:upper16:ctx_entry
				str		r2, [r1, #36]				/* lr 部分にエントリーアドレスを設定 */
				str		r1, [r0]					/* ctxcb に新 sp を保存 */
				bx		lr							/* リターン */

				.size	_kernel_cre_ctx, .-_kernel_cre_ctx


/************************************************
  実行コンテキストエントリーアドレス
 ************************************************/
				.thumb
				.thumb_func
				.type	ctx_entry, %function
ctx_entry:
				mov		r0, r5						/* par1を設定 */
				mov		r1, r6						/* par2を設定 */
				bx		r4							/* entry を実行 */

				.size	ctx_entry, .-ctx_entry


				.end


/* end of file */
