/* ------------------------------------------------------------------------ */
/* Hyper Operating System V4 Advance                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


				.h8300h




				.text


/************************************************
  実行コンテキストエントリーアドレス
************************************************/
ctx_entry:	
				mov.l	er4, er0				/* 実行時パラメータを第一引数に設定 */
				mov.l	er5, er1				/* 実行時パラメータを第一引数に設定 */
				jmp		@er3					/* 実行アドレスにジャンプ */


/************************************************
  実行コンテキストの作成
  _kernel_cre_ctx(
		_KERNEL_T_CTXCB *pk_ctxcb,				作成するコンテキスト [er0]
		VP              isp,					初期スタックポインタ [er1]
		FP              entry,					実行アドレス         [er2]
		VP_INT          par1,					実行時パラメータ1    [@(4, er7)]
		VP_INT          par2)					実行時パラメータ2    [@(8, er7)]
************************************************/
				.global	__kernel_cre_ctx
__kernel_cre_ctx:
				sub.l	#20, er1				/* エントリーポイント+er3〜er6 までの退避分 */
				mov.l	er1, @(0, er0)			/* スタックポインタの格納 */
				mov.l	#ctx_entry, er0
				mov.l	er0, @(16, er1)			/* 実行エントリーポイントの設定 */
				mov.l	er2, @(12, er1)			/* 実行アドレスの格納(er3部分) */
				mov.l	@(4, er7), er0
				mov.l	er0, @(8, er1)			/* 実行時パラメータ1の格納(er4部分) */
				mov.l	@(8, er7), er0
				mov.l	er0, @(4, er1)			/* 実行時パラメータ2の格納(er5部分) */
				rts


				.end


/* end of file */
