/*!
  @file
  @brief  25ΥʬεΥǡƥե¸륵ץץ
  @author aokaze (HARA Yoshitaka) <bluewind@roboken.esys.tsukuba.ac.jp>
  @author YoS (YOSHIDA Tomoaki) <yoshida@furo.org>
  @par    Publisher:
          HOKUYO AUTOMATIC CO.,LTD.
  @since  2006
  @date   2007/03/30
*/

#include "scipBase.h"
#include "scip1.h"
#include "scip2.h"
#include "scipUtil.h"

int main(int argc, char **argv)
{
  tPort *port;
  FILE *output;
  int **scan2;
  int i,j,id;
  int startStep,endStep,stepCluster,scanInterval,scanNum,stepNum;
  double x,y;

  // äƤʤϻȤɽ
  if(argc != 3){
    printf("USAGE:\n");
    printf(" %s dev_port_name output_file_name\n",argv[0]);
    printf(" ex) %s /dev/ttyS0 logfile.dat\n",argv[0]);
    exit(EXIT_SUCCESS);
  }

  // URG 󥵤³
  port=scipConnect(argv[1]);
  if(port==NULL){
    perror("Could not connect to the sensor ");
    exit(EXIT_FAILURE);
  }

#if 0
  // ̿®٤ѹ[Sޥ]
  if(scip1SetComSpeed(port,115200) != 0){
    fprintf(stderr,"Could not change speed\n");
    exit(EXIT_FAILURE);
  }

  // SCIP2.0 ⡼ɤ˰ܹ
  switchToScip2(port);

  // ̿®٤ѹ[SSޥ]
  if(scip2SetComSpeed(port,115200)!=0){
    fprintf(stderr,"Could not change speed\n");
    exit(EXIT_FAILURE);
  }

#endif

  // ϥե򳫤
  output=fopen(argv[2],"w");
  if(output==NULL){
    perror("Could not open output file");
    exit(EXIT_FAILURE);
  }

  // ǡޥɡMD/MSޥɡˤ5ȯ
  for(i=0; i<5; ++i){
    printf("Trying #%d\n",i);

    // ѥ᡼
    // ƥå 44-725 ƥåʬεΥǡְʤ22˼
    startStep=44;
    endStep=725;
    stepCluster=1;
    scanInterval=0;
    scanNum=2;

    // ¬ꤷƥǡ[MD/MSޥ]
    scan2=scip2MeasureScan(port,startStep,endStep,stepCluster,scanInterval,scanNum,ENC_3BYTE,&stepNum);

    if(scan2!=NULL){  // ե˵Ͽ
      for(j=0; j<scanNum; ++j){
        for(id=0; id<stepNum; ++id){
          // 顼ȽꡢɸѴ
          // ʥƥåֹˤֹƱǤϤʤȤ
          if(scan2[j][id] >= 20 && scan2[j][id] <= 5600){  // 
            x=scan2[j][id] * cos(step2rad(id2step(startStep,stepCluster,id)));
            y=scan2[j][id] * sin(step2rad(id2step(startStep,stepCluster,id)));
          } else  // 顼
            continue;

          // ʥƥåֹˡΥx ɸ͡y ɸͤե˵Ͽ
          fprintf(output,"%d %d %f %f\n",id2step(startStep,stepCluster,id),scan2[j][id],x,y);
        }
        fprintf(output,"\n");
      }
//       fprintf(output,"\n");

      // malloc εΥǡ free
      scip2FreeScan(scan2,scanNum);
    } else  // ˼
      fprintf(stderr,"#%d failed\n",i);
  }

  // ꤵ줿̿ϥɥĤ
  closePort(port);

  fclose(output);

  return EXIT_SUCCESS;
}
