/*
  Wii ɂ郍{bg

  Satofumi KAMIMURA

  $Id$
*/

#include "WiiJoystick.h"
#include "SimulationCtrl.h"
#include "RobotCtrl.h"
#include "Delay.h"


enum {
  MaxVelocity = 4,		// [km/h]
  DelayMsec = 100,		// [msec]
};


static void printHelp(const char* program_name) {
  printf("usage:\n\t%s\n"
	 "\n"
	 "options.\n"
	 "  -h,--help	print this message.\n",
	 program_name);
}


static void updateLed(int velocity_km, WiiJoystick& joystick) {

  static int pre_velocity_km = 0;
  if (velocity_km == pre_velocity_km) {
    // ڕWxɕωȂ΁Axw߂͍ĔsȂ
    return;
  }
  pre_velocity_km = velocity_km;

  // LED \̍XV
  if (velocity_km > 0) {
    // ~߂̂Ƃ́ALED XVȂ

    unsigned char led_bits = 0;
    for (int i = 0; i < velocity_km; ++i) {
      led_bits >>= 1;
      led_bits |= 0x8;
    }
    joystick.setLed(led_bits);
  }
}


static void radiconCtrl(RobotCtrlInterface* robot, WiiJoystick& joystick) {

  int velocity_km = 1;
  updateLed(velocity_km, joystick);

  bool up_pressed = false, down_pressed = false;
  bool quit = false;
  while (quit == false) {

    // Home ꂽA~R}h𔭍sďI
    if (joystick.isButtonPressed(WiiJoystick::Button_Home)) {
      quit = true;
      robot->stop();
      continue;
    }

    // sx̐ݒ
    if (joystick.isButtonPressed(WiiJoystick::Button_Plus)) {

      // ڕWxグBMaxVelcity 傫͂ȂȂ
      if ((up_pressed == false) && (velocity_km < MaxVelocity)) {
	++velocity_km;
	updateLed(velocity_km, joystick);
      }
      up_pressed = true;

    } else {
      up_pressed = false;
    }
    if (joystick.isButtonPressed(WiiJoystick::Button_Minus)) {

      // ڕWxB[ɂ͂ȂȂ
      if ((down_pressed == false) && (velocity_km > 1)) {
	--velocity_km;
	updateLed(velocity_km, joystick);
      }
      down_pressed = true;

    } else {
      down_pressed = false;
    }

    // i
    bool straight_pressed =
      joystick.isButtonPressed(WiiJoystick::Button_B) ||
      joystick.isButtonPressed(WiiJoystick::Button_A);

    if (straight_pressed) {
      //fprintf(stderr, "straight, ");
      // !!! iړR}h
      robot->setVelocity(velocity_km);

    } else {
      // ꂽ~Ƃ
      robot->stop();
    }

    // ]BsłȂƑǂȂ
    int handle = (straight_pressed > 0) ? joystick.getAxisValue(0) : 0;

    //fprintf(stderr, "%d, %d\n", straight_pressed, handle);

    if (handle < -30000) {
      // 
      // !!! ̃R}h
      //fprintf(stderr, "left, ");
      robot->setSteer(+20);

    } else if (handle > 30000) {
      // E
      // !!! ẼR}h
      //fprintf(stderr, "right, ");
      robot->setSteer(-20);

    } else {
      // i֑J
      // !!! [ʒuɖ߂߂̃R}h
      //fprintf(stderr, "no handle, ");
      robot->setSteer(0);
    }
    //fprintf(stderr, "\n");

    delay(DelayMsec);
    usleep(1);
  }
}


int main(int argc, char *argv[]) {

  // 
  bool simulation = false;
  for (int i = 1; i < argc; ++i) {
    if ((! strcmp("-s", argv[i])) || (! strcmp("--simulator", argv[i]))) {
      simulation = true;

    } else { //if ((! strcmp("-h", argv[i]) || (! strcmp("--help", argv[i])) {
      printHelp(argv[0]);
      exit(1);
    }
  }

  // Rg[ɐڑ
  printf("Put Wiimote in discoverable mode (press 1+2) and press RETURN\n");
  //getchar();

  WiiJoystick joystick;
  if (! joystick.connect()) {
    printf("WiiJoystick::connect: %s\n", joystick.what());
    exit(1);
  }

  // {bgɐڑ
  RobotCtrlInterface* robot;
  //if (simulation) {
    //robot = new SimulationCtrl;
  //} else {
    robot = new RobotCtrl;
    //}
  if (! robot->connect()) {
    printf("RobotCtrlInterface::connect: %s\n", robot->what());
    exit(1);
  }

  // WR̊Jn
  radiconCtrl(robot, joystick);

  // I
  delete robot;
  return 0;
}
