#ifndef ROBOT_CTRL_H
#define ROBOT_CTRL_H

/*
  ړ{bg̐

  Satofumi KAMIMURA

  $Id$
*/

#include "RobotCtrlInterface.h"
#include <memory>


class RobotCtrl : public RobotCtrlInterface {

  RobotCtrl(const RobotCtrl& rhs);
  RobotCtrl& operator = (const RobotCtrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  RobotCtrl(void);
  ~RobotCtrl(void);
  const char* what(void);
  bool updateEvent(void);

  bool connect(void);
  void startFollowLine(void);

  void setSteer(int degree);
  void setSteerOffset(int offset_degree);
  void setVelocity(int velocity_km);
  void follow_line(const CoordinateCtrl* crd, const Position<int>& position);
  int getLength_toLine(const CoordinateCtrl* crd, const Position<int>& line);
  void stop(void);
  int getVelocity(void);
  Position<int> getPosition(const CoordinateCtrl* crd);
  CoordinateCtrl* getCoordinate(void);
};

#endif /* !ROBOT_CTRL_H */
