(defun authorize (proj)
	(sql "begin")
	(progn
		(sql "select PID,Proj,PublicProj from Project where Proj=:proj"
			:bind ':proj proj
			:answer '(PID Proj Public))
		(if (emptyp PID)
				(sql "select PID,Proj,PublicProj from Project where Proj='Main'"
					:answer '(PID Proj Public))
		)
;
		(if (not-emptyp Public)
				(setvar 'Reader "1")
		)
;
		(set-wikivar 'PID 'Proj 'Public 'Reader)
;
		(setvar 'uid (remote-user))
		(sql "select UID,Login,Name,Pron,Org,Mail from Member where UID=:uid"
			:bind ':uid uid
			:answer '(UID Login Name Pron Org Mail))
		(set-wikivar 'UID 'Login 'Name 'Pron 'Org 'Mail)
		(if (emptyp UID)
				(break)
		)
;
		(sql "select '1' from Permission where UID=:uid and Realm='Admin'"
			:bind ':uid UID
			:answer '(Admin))
;
		(if (not-emptyp Public)
				(setvar 'Reader "1"
						'Writer "1")
			(sql "select Realm from ProjectMember where PID=:pid and UID=:uid"
				:bind (list ':pid PID ':uid UID)
				:@answer '(realm))
			(doarray '(realm)
				(setvar 'v (concat "Auth_" realm)
						v "1")
				(set-wikivar v)
			)
			(setvar 'Reader (getvar "Auth_Reader")
					'Writer (getvar "Auth_Writer"))
		)
;
		(set-wikivar 'Admin 'Reader 'Writer)
	)
	(sql "end")
)

(defun wiki-page (pid page)
	(let (wid date title text)
		(sql "select a.WID,a.Title,a.WikiText,b.Date from Wiki a,WikiIndex b using(WID) where b.PID=:pid and b.Page=:page"
			:bind (list ':pid pid ':page page)
			:answer '(wid title text date))
		(if (and	(emptyp wid)
					(regex "^-special-" page))
				(sql "select a.WID,a.Title,a.WikiText,b.Date from Wiki a,WikiIndex b using(WID),Project c using(PID) where c.Proj='Main' and b.Page=:page"
					:bind (list ':page page)
					:answer '(wid title text date))
		)

		(if (and (emptyp wid) Edit)
				(setvar 'title page
						'text (concat "=" page "=\n"))
		)
		(list date title text)
	)
)

(defun wiki-page-backup-list (page vdate)
	(sql "select Date from BackupIndex where PID=:pid and Page=:page order by Date desc"
		:bind (list ':pid PID ':page page)
		:@answer (list vdate))
)

(defun wiki-page-date (page date)
	(let (title text)
		(if (emptyp date)
				(sql "select b.Title,b.WikiText from WikiIndex a,Wiki b using(WID) where a.PID=:pid and a.Page=:page"
					:bind (list ':pid PID ':page page)
					:answer '(title text))
			(sql "select b.Title,b.WikiText from BackupIndex a,Wiki b using(WID) where a.PID=:pid and a.Page=:page and Date=:date"
				:bind (list ':pid PID ':page page ':date date)
				:answer '(title text))
		)
		(list title text)
	)
)

(defun wiki-save (page title text)
	(let (iid wid date uid nwid)
		(sql "begin")
		(sql "select IID,WID,Date,UID from WikiIndex where PID=:pid and Page=:page"
			:bind (list ':pid PID ':page page)
			:answer '(iid wid date uid))
		(if (and	(not-emptyp wid)
					(> date (- (now) 10800))
					(= uid UID))
				(progn	(sql "update Wiki set Title=:title,WikiText=:text where WID=:wid"
							:bind (list ':title title ':text text ':wid wid))
						(sql "update WikiIndex set IP=:ip,Date=:date where IID=:iid"
							:bind (list ':ip (remote-ip) ':date (now) ':iid iid))
				)
			(sql "insert into Wiki(Title,WikiText) values(:title,:text)"
				:bind (list ':title title ':text text))
			(setvar 'nwid (rowid))
			(if (emptyp iid)
					(sql "insert into WikiIndex(PID,Page,UID,IP,Date,WID) values(:pid,:page,:uid,:ip,:date,:wid)"
						:bind (list ':pid PID ':page page ':uid UID ':ip (remote-ip) ':date (now) ':wid nwid))
				(sql "insert into BackupIndex(PID,Page,UID,IP,Date,WID) select PID,Page,UID,IP,Date,WID from WikiIndex where IID=:iid"
					:bind ':iid iid)
				(sql "update WikiIndex set UID=:uid,IP=:ip,Date=:date,WID=:wid where IID=:iid"
					:bind (list ':uid UID ':ip (remote-ip) ':date (now) ':wid nwid ':iid iid))
			)
		)
		(sql "end")
	)
)

(defun wiki-delete (page)
	(sql "begin")
	(sql "insert into BackupIndex(PID,Page,UID,IP,Date,WID) select PID,Page,UID,IP,Date,WID from WikiIndex where PID=:pid and Page=:page"
		:bind (list ':pid PID ':page page))
	(sql "delete from WikiIndex where PID=:pid and Page=:page"
		:bind (list ':pid PID ':page page))
	(sql "end")
)

(defun wiki-page-index (cat vpage vtitle)
	(if (null cat)
			(progn
				(sql "select a.Page,b.Title from WikiIndex a,Wiki b using(WID) where a.PID=:pid and a.Page not like 'special-%' order by a.Page"
					:bind ':pid PID
					:@answer (list vpage vtitle))
			)
		(if (emptyp cat)
				(sql "select a.Page,b.Title from WikiIndex a,Wiki b using(WID) where a.PID=:pid and a.IID not in (select IID from WikiCategory where PID=:pid) and a.Page not like 'special-%' order by a.Page"
					:bind (list ':pid PID)
					:@answer (list vpage vtitle))
			(sql "select a.Page,b.Title from CategoryList c,WikiCategory d using(CID),WikiIndex a using(IID),Wiki b using(WID) where a.PID=:pid and c.CName=:cat and a.Page not like 'special-%'  order by a.Page"
				:bind (list ':pid PID ':cat cat)
				:@answer (list vpage vtitle))
		)
	)
)

(defun wiki-page-index-special (vpage vtitle)
	(sql "select a.Page,b.Title from WikiIndex a,Wiki b using(WID) where a.PID=:pid and a.Page like 'special-%' order by a.Page"
		:bind ':pid PID
		:@answer (list vpage vtitle))
)

(defun wiki-category-index (vname)
	(sql "select CName from CategoryList where PID=:pid order by CName"
		:bind ':pid PID
		:@answer (list vname))
)

(defun wiki-add-category (name)
	(if (not-emptyp name)
			(sql "insert into CategoryList(PID,CName) values(:pid,:cat)"
				:bind (list ':pid PID ':cat name))
	)
)

(defun wiki-delete-category (name)
	(sql "begin")
	(sql "delete from WikiCategory where CID in (select CID from CategoryList where PID=:pid and CName=:cat)"
		:bind ':pid PID ':cat cat)
	(sql "delete from CategoryList where PID=:pid and CName=:cat"
		:bind ':pid PID ':cat cat)
	(sql "end")
)

(defun wiki-set-category (page vlist)
	(let (iid)
		(sql "begin")
		(sql "select IID from WikiIndex where PID=:pid and Page=:page"
			:bind (list ':pid PID ':page page)
			:answer '(iid))
		(if (not-emptyp iid)
				(progn	(sql "delete from WikiCategory where IID=:iid"
							:bind ':iid iid)
						(doarray vlist
							(sql "insert into WikiCategory(PID,IID,CID) select :pid,:iid,CID from CategoryList where PID=:pid and CName=:name"
								:bind (list ':pid PID ':iid iid ':name vlist))
						)
				)
		)
		(sql "end")
	)
)

(defun wiki-search (key vpage vtitle vsp)
	($estcmd 'wiki-index
		(search key
			:attribute "Page" vpage
			:attribute "@title" vtitle
			:snippet vsp
			:cond (concat "Proj STREQ " PID))
	)
	(doarray (list vtitle)
		(if (emptyp (getvar vtitle))
				(setvar vtitle "<タイトル未設定>")
		)
	)
)

(defun wiki-diff (page otime ntime vo1 vo2 vn1 vn2)
	(let (otitle otext ntitle ntext)
		(setvar '(otitle otext) (wiki-page-date page otime)
			'(ntitle ntext) (wiki-page-date page ntime)
			(list (concat '@ vo1) (concat '@ vo2) (concat '@ vn1) (concat '@ vn2)) (diff otext ntext))
	)
)
