/*
	$Id: User.cs 23 2010-01-16 18:25:12Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;

namespace Hiyoko.Net.Twitter{
	public struct User{
		public decimal Id{get; private set;}
		public string Name{get; private set;}
		public string ScreenName{get; private set;}
		public string Location{get; private set;}
		public string Description{get; private set;}
		public string ProfileImageUrl{get; private set;}
		public string Url{get; private set;}
		public bool Protected{get; private set;}
		public int FollowersCount{get; private set;}
		public int ProfileBackgroundColor{get; private set;}
		public int ProfileTextColor{get; private set;}
		public int ProfileLinkColor{get; private set;}
		public int ProfileSidebarFillColor{get; private set;}
		public int ProfileSidebarBorderColor{get; private set;}
		public int FriendsCount{get; private set;}
		public DateTime CreatedAt{get; private set;}
		public int FavouritesCount{get; private set;}
		public int UtcOffset{get; private set;}
		public string TimeZone{get; private set;}
		public string ProfileBackgroundImageUrl{get; private set;}
		public bool ProfileBackgroundTile{get; private set;}
		public string Notifications{get; private set;}
		public bool GeoEnabled{get; private set;}
		public bool Verified{get; private set;}
		public string Following{get; private set;}
		public int StatusesCount{get; private set;}
		
		public static User FromXElement(XElement element){
			User user = new User();
			user.Id = (decimal)element.Element("id");
			user.Name = (string)element.Element("name");
			user.ScreenName = (string)element.Element("screen_name");
			user.Location = (string)element.Element("location");
			user.Description = (string)element.Element("description");
			user.ProfileImageUrl = (string)element.Element("profile_image_url");
			user.Url = (string)element.Element("url");
			user.Protected = (bool)element.Element("protected");
			user.FollowersCount = (int)element.Element("followers_count");
			
			user.ProfileBackgroundColor = Convert.ToInt32((string)element.Element("profile_background_color"), 16);
			user.ProfileTextColor = Convert.ToInt32((string)element.Element("profile_text_color"), 16);
			user.ProfileLinkColor = Convert.ToInt32((string)element.Element("profile_link_color"), 16);
			user.ProfileSidebarFillColor = Convert.ToInt32((string)element.Element("profile_sidebar_fill_color"), 16);
			user.ProfileSidebarBorderColor = Convert.ToInt32((string)element.Element("profile_sidebar_border_color"), 16);
			user.FriendsCount = (int)element.Element("friends_count");
			DateTime dt;
			if(TwitterAPI.TryParseDateTime((string)element.Element("created_at"), out dt)){
				user.CreatedAt = dt;
			}
			user.FavouritesCount = (int)element.Element("favourites_count");
			int n;
			if(Int32.TryParse((string)element.Element("utc_offset"), out n)){
				user.UtcOffset = n;
			}
			user.TimeZone = (string)element.Element("time_zone");
			user.ProfileBackgroundImageUrl = (string)element.Element("profile_background_image_url");
			user.ProfileBackgroundTile = (bool)element.Element("profile_background_tile");
			user.Notifications = (string)element.Element("notifications");
			user.GeoEnabled = (bool)element.Element("geo_enabled");
			user.Verified = (bool)element.Element("verified");
			user.Following = (string)element.Element("following");
			user.StatusesCount = (int)element.Element("statuses_count");
			
			return user;
		}
		
		public override bool Equals(object obj){
			if(obj is User){
				return this.Id.Equals(((User)obj).Id);
			}else{
				return false;
			}
		}
		
		public static bool operator ==(User a, User b){
			return (a.Id == b.Id);
		}
		
		public static bool operator !=(User a, User b){
			return (a.Id != b.Id);
		}
		
		public override int GetHashCode(){
			return this.Id.GetHashCode();
		}
	}
}