using System;
using System.IO;
using System.Net;

namespace Hiyoko.Net{
	public class WebRequestData{
		public WebRequest WebRequest{get; private set;}
		public byte[] RequestData{get; private set;}
		
		public WebRequestData(WebRequest req) : this(req, null){
		}
		
		public WebRequestData(WebRequest req, byte[] data){
			this.WebRequest = req;
			this.RequestData = data;
		}
		
		public void WriteRequestData(){
			if(this.RequestData == null){
				throw new InvalidOperationException();
			}
			using(Stream stream = this.WebRequest.GetRequestStream()){
				stream.Write(this.RequestData, 0, this.RequestData.Length);
			}
		}
		
		public void WriteRequestData(Stream stream){
			if(this.RequestData == null){
				throw new InvalidOperationException();
			}
			stream.Write(this.RequestData, 0, this.RequestData.Length);
		}
	}
}