/*
	$Id: MainForm.cs 15 2010-01-07 17:45:08Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.IO;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Xml.Linq;
using Hiyoko.Net;
using Hiyoko.Net.Twitter;
using Hiyoko.Utilities;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	
	public partial class MainForm : Window{
		private DateTime latestTimelineStatusDate = Program.Settings.LatestTimelineStatusDate;
		private DispatcherTimer autoRefreshTimelineTimer = new DispatcherTimer(DispatcherPriority.Background);
		private Gdi.Icon emptyIcon;
		private Gdi.Icon letterIcon;
		private ObservableCollection<OutputItem> outputs;
		private ObservableCollection<Status> timeline;
		private Account currentAccount = new Account(Program.Settings.AccessToken);
		private WinForms.ContextMenu notifyIconContextMenu = new WinForms.ContextMenu();
		private WinForms.NotifyIcon notifyIcon = new WinForms.NotifyIcon();
		private WindowSettings windowSettings = new WindowSettings("MainForm");
		private WindowState restoreState;
		private XElement timelineXml = null;
		private List<Status> newTimelineStatusesNotShown = new List<Status>();
		private double autoRefreshTimelineWeight = 1;
		private Semaphore refreshTimelineSemaphore = new Semaphore(1, 1);
		private Semaphore updateStatusSemaphore = new Semaphore(1, 1);
		private Semaphore shortenUrlStatusEditSemaphore = new Semaphore(1, 1);
		private Semaphore uploadImageSemaphore = new Semaphore(1, 1);
		private NetworkJobServer networkJobServer = new NetworkJobServer();
		private OutputPanelTraceListener traceListener;
		private UrlShorter urlShorter = null;
		private HotKeyManager hotKeyManager;
		
		public MainForm(){
			this.InitializeComponent();
			
			this.hotKeyManager = new HotKeyManager(this);
			
			this.outputs = new ObservableCollection<OutputItem>(new SkipList<OutputItem>());
			this.outputs.CollectionChanged += this.Outputs_CollectionChanged;
			this.outputList.DataContext = this.outputs;
			
			this.timeline = new ObservableCollection<Status>();
			this.timelineList.DataContext = this.timeline;
			
			// ʒmACR
			System.Reflection.Assembly asm = System.Reflection.Assembly.GetExecutingAssembly();
			this.letterIcon = new Gdi.Icon(asm.GetManifestResourceStream("Resources.Letter.ico"));
			this.emptyIcon = new Gdi.Icon(asm.GetManifestResourceStream("Resources.Empty.ico"));
			this.notifyIcon.Icon = this.emptyIcon;
			this.notifyIcon.MouseClick += this.NotifyIcon_MouseClick;
			this.notifyIcon.Text = "Hiyoko - A Twitter Client";
			
			// ʒmACR̃ReLXgj[B
			this.notifyIconContextMenu.MenuItems.Add(new WinForms.MenuItem("\(&V)", delegate{
				this.ShowWindow();
			}));
			this.notifyIconContextMenu.MenuItems.Add(new WinForms.MenuItem("-"));
			this.notifyIconContextMenu.MenuItems.Add(new WinForms.MenuItem("ݒ(&S)...", delegate{
				SettingsForm settings = new SettingsForm();
				settings.Owner = this;
				settings.ShowDialog();
			}));
			this.notifyIconContextMenu.MenuItems.Add(new WinForms.MenuItem("-"));
			this.notifyIconContextMenu.MenuItems.Add(new WinForms.MenuItem("I(&V)", delegate{
				Application.Current.Shutdown();
			}));
			this.notifyIcon.ContextMenu = this.notifyIconContextMenu;
			
			// EChE
			this.windowSettings.UpgradeOnce();
			this.Left = ValidPositionValue(this.windowSettings.RestoreBounds.Left);
			this.Top = ValidPositionValue(this.windowSettings.RestoreBounds.Top);
			this.Width = ValidSizeValue(this.windowSettings.RestoreBounds.Width);
			this.Height = ValidSizeValue(this.windowSettings.RestoreBounds.Height);
			this.WindowState = this.restoreState = this.windowSettings.WindowState;
			this.outputListRow.Height = Program.Settings.OutputListRowHeight;
			this.timelineStatusEditRow.Height = Program.Settings.TimelineStatusEditRowHeight;
			
			// Cxg
			Program.Settings.PropertyChanged += this.ApplicationSettings_Changed;
			((ObjectDataProvider)this.Resources["networkJobServerProvider"]).ObjectInstance = this.networkJobServer;
			this.networkJobServer.JobCompleted += delegate{
				((ObjectDataProvider)this.Resources["networkJobServerProvider"]).Refresh();
			};
			this.networkJobServer.JobRunning += delegate{
				((ObjectDataProvider)this.Resources["networkJobServerProvider"]).Refresh();
			};
			this.networkJobServer.JobEnqueued += delegate{
				((ObjectDataProvider)this.Resources["networkJobServerProvider"]).Refresh();
			};
			
			// TraceListener
			this.traceListener = new OutputPanelTraceListener(this);
			Debug.Listeners.Add(this.traceListener);
			
			// ^C}[
			this.autoRefreshTimelineTimer.Tick += this.AutoRefreshTimelineTimer_Tick;
			this.autoRefreshTimelineTimer.Interval = TimeSpan.FromSeconds(60);
			this.CalculateAutoRefreshTimelineInterval();
			this.autoRefreshTimelineTimer.IsEnabled = Program.Settings.IsAutoRefreshTimeline;
			
			// UrlShorter
			if(!String.IsNullOrEmpty(Program.Settings.BitlyApiKey)){
				this.urlShorter = new Bitly(Program.Settings.BitlyLogin, Program.Settings.BitlyApiKey);
				((ExpandUrlsConverter)this.Resources["StatusTextExpandUrlsConverter"]).UrlShorter = this.urlShorter;
			}
			
			// 
			this.RefreshStatusEditCount();
			this.CurrentTimelinePage = 1;
		}
		
		private static double ValidSizeValue(double v){
			return ValidPositionValue(v);
		}
		
		private static double ValidPositionValue(double v){
			return ((Double.NegativeInfinity < v) && (v < Double.PositiveInfinity)) ? v : Double.NaN;
		}
		
		#region Cxg
		
		protected override void OnInitialized(EventArgs e){
			base.OnInitialized(e);
			if(Program.Settings.IsResident){
				this.notifyIcon.Visible = true;
			}
			this.restoreState = this.WindowState;
		}
		
		protected override void OnClosing(CancelEventArgs e){
			base.OnClosing(e);
			this.windowSettings.RestoreBounds = this.RestoreBounds;
			if(this.WindowState != WindowState.Minimized){
				this.windowSettings.WindowState = this.WindowState;
			}
			Program.Settings.OutputListRowHeight = this.outputListRow.Height;
			Program.Settings.TimelineStatusEditRowHeight = this.timelineStatusEditRow.Height;
			
			if(Program.Settings.IsResident){
				e.Cancel = true;
				this.Hide();
			}
		}
		
		protected override void OnClosed(EventArgs e){
			base.OnClosed(e);
			Program.Settings.LatestTimelineStatusDate = this.latestTimelineStatusDate;
			this.windowSettings.Save();
			this.notifyIcon.Visible = false;
			this.notifyIcon.Dispose();
			this.letterIcon.Dispose();
			this.emptyIcon.Dispose();
			this.autoRefreshTimelineTimer.Stop();
			Program.Settings.PropertyChanged -= this.ApplicationSettings_Changed;
			Debug.Listeners.Remove(this.traceListener);
		}
		
		protected override void OnActivated(EventArgs e){
			this.notifyIcon.Icon = this.emptyIcon;
			this.newTimelineStatusesNotShown.Clear();
			this.notifyIcon.Text = "Hiyoko - A Twitter Client";
			base.OnActivated(e);
			this.Dispatcher.BeginInvoke(DispatcherPriority.Background, new Action(delegate{
				CommandManager.InvalidateRequerySuggested();
			}));
		}
		
		protected override void OnStateChanged(EventArgs e){
			if(this.WindowState != WindowState.Minimized){
				this.restoreState = this.WindowState;
			}
			base.OnStateChanged(e);
			this.Dispatcher.BeginInvoke(DispatcherPriority.Background, new Action(delegate{
				CommandManager.InvalidateRequerySuggested();
			}));
		}
		
		private void NotifyIcon_MouseClick(object sender, WinForms.MouseEventArgs e){
			if((e.Button & WinForms.MouseButtons.Left) > 0){
				this.ShowWindow();
			}
		}
		
		public void ShowWindow(){
			this.Show();
			this.Activate();
			this.WindowState = this.restoreState;
		}
		
		private void ApplicationSettings_Changed(object sender, PropertyChangedEventArgs e){
			ApplicationSettings settings = (ApplicationSettings)sender;
			switch(e.PropertyName){
				case "IsResident":{
					this.notifyIcon.Visible = settings.IsResident;
					break;
				}
				case "IsAutoRefreshTimeline":{
					this.autoRefreshTimelineTimer.IsEnabled = settings.IsAutoRefreshTimeline;
					this.CalculateAutoRefreshTimelineInterval();
					break;
				}
				/*case "AutoRefreshTimelineInterval":{
					this.autoRefreshTimelineTimer.Interval = TimeSpan.FromSeconds(settings.AutoRefreshTimelineInterval);
					break;
				}*/
				case "AccessToken":{
					this.currentAccount.AccessToken = settings.AccessToken;
					break;
				}
				case "WebProxyUri":
				case "IsUseWebProxy":{
					if(settings.IsUseWebProxy){
						TwitterAPI.Proxy = new WebProxy(settings.WebProxyUri);
					}else{
						TwitterAPI.Proxy = WebRequest.DefaultWebProxy;
					}
					break;
				}
				case "BitlyApiKey":
				case "BitlyLogin":{
					this.urlShorter = (String.IsNullOrEmpty(settings.BitlyApiKey)) ? null : new Bitly(settings.BitlyLogin, settings.BitlyApiKey);
					((ExpandUrlsConverter)this.Resources["StatusTextExpandUrlsConverter"]).UrlShorter = this.urlShorter;
					break;
				}
			}
		}
		
		private void AutoRefreshTimelineTimer_Tick(object sender, EventArgs e){
			if(IsAvailable(this.refreshTimelineSemaphore)){
				if(this.IsActive){
					if(this.CurrentTimelinePage == 1){
						this.RefreshTimeline(true);
					}
				}else{
					this.RefreshTimeline(true);
				}
			}
		}
		
		/*
		private void ListBoxItem_MouseDoubleClick(object sender, MouseButtonEventArgs e){
			ListBoxItem item = (ListBoxItem)sender;
			ContentControl content = (COnitem.Content;
			ModifierKeys mods = Keyboard.Modifiers;
			MouseAction action = (e.ChangedButton == MouseButton.Left) ? MouseAction.LeftDoubleClick :
			                     (e.ChangedButton == MouseButton.Right) ? MouseAction.RightDoubleClick :
			                     (e.ChangedButton == MouseButton.Middle) ? MouseAction.MiddleDoubleClick :
			                     MouseAction.None;
			MessageBox.Show(action.ToString());
			if(action != MouseAction.None){
				foreach(MouseBinding binding in ((ContentElement)sender).InputBindings.Cast<MouseBinding>()
				                                                    .Where(bind => (((MouseGesture)bind.Gesture).MouseAction == action))
				                                                    .Where(bind => (((MouseGesture)bind.Gesture).Modifiers == mods))){
					ICommand command = binding.Command;
					RoutedCommand routedCommand = command as RoutedCommand;
					if((routedCommand != null) && (routedCommand.CanExecute(binding.CommandParameter, binding.CommandTarget))){
						routedCommand.Execute(binding.CommandParameter, binding.CommandTarget);
					}else if(command.CanExecute(binding.CommandParameter)){
						command.Execute(binding.CommandParameter);
					}
				}
			}
		}
		
		/*
		private void TimelineItem_MouseDown(object sender, MouseButtonEventArgs e){
			if((e.ClickCount > 1) && HiyokoCommands.OpenUrls.CanExecute(this.timelineTabItem, null)){
				HiyokoCommands.OpenUrls.Execute(this.timelineTabItem, null);
			}
		}
		*/
		#endregion
		
		#region R}h
		
		private void About_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void About_Executed(object target, ExecutedRoutedEventArgs e){
			AboutForm about = new AboutForm();
			about.Owner = this;
			about.ShowDialog();
		}
		
		private void AbortCommunication_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = this.networkJobServer.IsBusy;
		}
		
		private void AbortCommunication_Executed(object target, ExecutedRoutedEventArgs e){
			this.networkJobServer.AbortJob();
		}
		
		private void Settings_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Settings_Executed(object target, ExecutedRoutedEventArgs e){
			SettingsForm settings = new SettingsForm();
			settings.Owner = this;
			settings.ShowDialog();
		}
		
		private void Exit_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Exit_Executed(object target, ExecutedRoutedEventArgs e){
			Application.Current.Shutdown();
		}
		
		private void Close_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Close_Executed(object target, ExecutedRoutedEventArgs e){
			this.Close();
		}
		
		private void SaveTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineXml != null);
		}
		
		private void SaveTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			WinForms.SaveFileDialog dlg = new WinForms.SaveFileDialog();
			dlg.Filter = "Xmlt@C|*.xml";
			dlg.DefaultExt = "xml";
			if(dlg.ShowDialog() == WinForms.DialogResult.OK){
				this.timelineXml.Save(dlg.FileName);
			}
		}
		
		private void Refresh_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = IsAvailable(this.refreshTimelineSemaphore);
		}
		
		private void Refresh_Executed(object target, ExecutedRoutedEventArgs e){
			this.RefreshTimeline(false);
		}
		
		private void UpdateStatus_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (0 < this.statusEdit.Text.Length) && (this.statusEdit.Text.Length <= 140) && IsAvailable(this.updateStatusSemaphore);
		}
		
		private void UpdateStatus_Executed(object target, ExecutedRoutedEventArgs e){
			this.UpdateStatus();
		}
		
		private void OpenTwitterCom_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void OpenTwitterCom_Executed(object target, ExecutedRoutedEventArgs e){
			Process.Start("http://twitter.com");
		}
		
		private void OpenMyHome_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void OpenMyHome_Executed(object target, ExecutedRoutedEventArgs e){
			Process.Start("http://twitter.com/home");
		}
		
		#endregion
		
		#region R}h - Timeline
		
		private void OpenUrlsTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineList.SelectedValue != null);
		}
		
		private void OpenUrlsTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			foreach(string url in this.timelineList.SelectedItems.Cast<Status>()
			                                                     .SelectMany(status => status.Text.ExtractUrls())
			                                                     .Distinct()){
				Process.Start(url);
			}
		}
		
		private void OpenHomeTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineList.SelectedValue != null);
		}
		
		private void OpenHomeTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			foreach(string url in this.timelineList.SelectedItems.Cast<Status>()
			                                                     .Select(status => "http://twitter.com/" + status.User.ScreenName)
			                                                     .Distinct()){
				Process.Start(url);
			}
		}
		
		private void OpenSiteTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineList.SelectedValue != null);
		}
		
		private void OpenSiteTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			foreach(string url in this.timelineList.SelectedItems.Cast<Status>()
			                                                     .Select(status => status.User.Url)
			                                                     .Where(url => !String.IsNullOrEmpty(url))
			                                                     .Distinct()){
				Process.Start(url);
			}
		}
		
		private void CopyStatus_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineList.SelectedValue != null);
		}
		
		private void CopyStatus_Executed(object target, ExecutedRoutedEventArgs e){
			StringBuilder sb = new StringBuilder();
			foreach(Status status in this.timelineList.SelectedItems){
				sb.AppendFormat("@{0} {1}\n", status.User.ScreenName, status.Text);
			}
			Clipboard.SetData(DataFormats.Text, sb.ToString());
		}
		
		private void CreateFavoriteTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineList.SelectedValue != null);
		}
		
		private void CreateFavoriteTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			if(this.timelineList.SelectedItems.Count > 0){
				this.CreateFavorite(this.timelineList.SelectedItems.Cast<Status>());
			}
		}
		
		private void CreateBlockTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineList.SelectedValue != null);
		}
		
		private void CreateBlockTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			if(this.timelineList.SelectedItems.Count > 0){
				this.CreateBlock(this.timelineList.SelectedItems.Cast<Status>());
			}
		}
		
		private void DestroyStatus_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineList.SelectedValue != null);
		}
		
		private void DestroyStatus_Executed(object target, ExecutedRoutedEventArgs e){
			if(MessageBox.Show("IXe[^X폜܂B\n낵łH", "mF", MessageBoxButton.YesNo) == MessageBoxResult.Yes){
				if(this.timelineList.SelectedItems.Count > 0){
					this.DestroyStatus(this.timelineList.SelectedItems.Cast<Status>());
				}
			}
		}
		
		private void DestroyFriendshipTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.timelineList.SelectedValue != null);
		}
		
		private void DestroyFriendshipTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			if(MessageBox.Show("I[U[̃tH[폜܂B\n낵łH", "mF", MessageBoxButton.YesNo) == MessageBoxResult.Yes){
				if(this.timelineList.SelectedItems.Count > 0){
					this.DestroyFriendship(this.timelineList.SelectedItems.Cast<Status>());
				}
			}
		}
		
		private void ScrollPageUpTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void ScrollPageUpTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			ScrollViewer sv = GetScrollViewer(this.timelineList);
			if(sv != null){
				sv.LineLeft();
			}else{
				Debug.WriteLine(new ErrorOutputItem("can`t find sv"));
			}
		}
		
		private void ScrollPageDownTimeline_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void ScrollPageDownTimeline_Executed(object target, ExecutedRoutedEventArgs e){
			ScrollViewer sv = GetScrollViewer(this.timelineList);
			if(sv != null){
				sv.LineRight();
			}else{
				Debug.WriteLine(new ErrorOutputItem("can`t find sv"));
			}
		}
		
		private void ShortenUrlStatusEdit_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = (this.urlShorter != null) && IsAvailable(this.shortenUrlStatusEditSemaphore);
		}
		
		private void ShortenUrlStatusEdit_Executed(object target, ExecutedRoutedEventArgs e){
			this.ShortenUrlStatusEdit();
		}
		
		private void UploadImageStatusEdit_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = !(String.IsNullOrEmpty(Program.Settings.TwitpicUsername)) && IsAvailable(this.uploadImageSemaphore);
		}
		
		private void UploadImageStatusEdit_Executed(object target, ExecutedRoutedEventArgs e){
			WinForms.OpenFileDialog dlg = new WinForms.OpenFileDialog();
			dlg.Filter = "摜t@C|*.jpg;*.jpeg;*.png;*.gif";
			if(dlg.ShowDialog() == WinForms.DialogResult.OK){
				this.statusEdit.IsReadOnly = true;
				this.UploadImage(dlg.FileName, delegate(string url){
					this.statusEdit.IsReadOnly = false;
					if(url != null){
						this.statusEdit.SelectedText = url;
					}
				});
			}
		}
		
		#endregion
		
		#region R}h - Pager
		
		private void FirstPage_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = this.timelineTabItem.IsSelected && (this.CurrentTimelinePage != 1) && IsAvailable(this.refreshTimelineSemaphore);
		}
		
		private void FirstPage_Executed(object target, ExecutedRoutedEventArgs e){
			if(this.timelineTabItem.IsSelected){
				this.CurrentTimelinePage = 1;
				this.RefreshTimeline(false);
			}
		}
		
		private void NextPage_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = this.timelineTabItem.IsSelected && (this.timeline != null) && (this.timeline.Count > 0) && IsAvailable(this.refreshTimelineSemaphore);
		}
		
		private void NextPage_Executed(object target, ExecutedRoutedEventArgs e){
			if(this.timelineTabItem.IsSelected){
				this.CurrentTimelinePage++;
				this.RefreshTimeline(false);
			}
		}
		
		private void PreviousPage_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = this.timelineTabItem.IsSelected && (this.CurrentTimelinePage > 1) && IsAvailable(this.refreshTimelineSemaphore);
		}
		
		private void PreviousPage_Executed(object target, ExecutedRoutedEventArgs e){
			if(this.timelineTabItem.IsSelected){
				this.CurrentTimelinePage--;
				this.RefreshTimeline(false);
			}
		}
		
		#endregion
		
		#region ^CC
		
		private void RefreshTimeline(){
			this.RefreshTimeline(false);
		}
		
		private void RefreshTimeline(bool isAuto){
			P(this.refreshTimelineSemaphore);
			if(this.autoRefreshTimelineTimer.IsEnabled){
				this.autoRefreshTimelineTimer.Stop();
				this.autoRefreshTimelineTimer.Start();
			}
			int page = this.CurrentTimelinePage;
			this.networkJobServer.EnqueueJob(delegate{
					this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
						this.outputs.Add(new MessageOutputItem("^CC擾..."));
					}));
					return TwitterAPI.GetHomeTimeline(this.currentAccount, Program.Settings.TimelineCount, page, 0, 0);
				},
				null,
				delegate(NetworkJobData data){
					try{
						// ^CC擾
						string xmlString;
						Collection<Status> timeline = new Collection<Status>();
						using(HttpWebResponse res = (HttpWebResponse)data.WebRequestData.WebRequest.EndGetResponse(data.AsyncResult))
						using(Stream stream = res.GetResponseStream()){
							using(StreamReader reader = new StreamReader(stream, Encoding.UTF8)){
								xmlString = reader.ReadToEnd();
							}
						}
						this.timelineXml = XElement.Parse(xmlString);
						foreach(XElement status in this.timelineXml.Elements("status")){
							timeline.Add(new Status(status));
						}
						
						// VXe[^X
						Status[] newStatuses = timeline.Where(status => (status.CreatedAt > this.latestTimelineStatusDate))
						                               .OrderByDescending(status => status.CreatedAt).ToArray();
						if(newStatuses.Length > 0){
							this.latestTimelineStatusDate = newStatuses[0].CreatedAt;
						}
						
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							// o[`bv
							if((newStatuses.Length > 0) && this.notifyIcon.Visible && !this.IsActive){
								StringBuilder sb = new StringBuilder();
								foreach(Status status in newStatuses){
									sb.AppendFormat("{0} / {1}\n", status.User.Name, status.User.ScreenName);
									sb.AppendFormat("{0}\n", status.Text);
								}
								this.newTimelineStatusesNotShown.AddRange(newStatuses);
								this.notifyIcon.ShowBalloonTip(
									10000,
									String.Format("VXe[^X {0} /  {1}", newStatuses.Length, this.newTimelineStatusesNotShown.Count),
									sb.ToString(),
									WinForms.ToolTipIcon.None);
								this.notifyIcon.Icon = this.letterIcon;
								this.notifyIcon.Text = String.Format("Hiyoko - A Twitter Client\nV{0}", this.newTimelineStatusesNotShown.Count);
							}
							
							// AEgvbgbZ[W
							if(newStatuses.Length > 0){
								this.outputs.Add(new SuccessOutputItem(String.Format("^CC擾 V{0}", newStatuses.Length)));
							}else{
								this.outputs.Add(new SuccessOutputItem("^CC擾"));
							}
							
							// ^CCXV
							Status diff = timeline.Except(this.timeline).FirstOrDefault();
							if(diff != null){
								this.timeline.Clear();
								foreach(Status stat in timeline){
									this.timeline.Add(stat);
								}
								if(this.timeline.Count > 0){
									this.timelineList.ScrollIntoView(this.timeline[0]);
								}
							}
							
							// C^[o
							if(isAuto){
								if(newStatuses.Length > 0){
									this.autoRefreshTimelineWeight = 1;
								}else{
									this.autoRefreshTimelineWeight *= 0.5;
								}
							}
							if(this.autoRefreshTimelineTimer.IsEnabled){
								this.CalculateAutoRefreshTimelineInterval();
								this.outputs.Add(new MessageOutputItem(String.Format(
									"̎擾 {0} ",
									Math.Round(this.autoRefreshTimelineTimer.Interval.TotalMinutes))));
							}
							
							CommandManager.InvalidateRequerySuggested();
						}));
					}catch(WebException ex){
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
							this.timeline.Clear();
						}));
					}
				},
				delegate{
					V(this.refreshTimelineSemaphore);
				}
			); 
		}
		
		private void UpdateStatus(){
			P(this.updateStatusSemaphore);
			string status = this.statusEdit.Text;
			this.statusEdit.IsReadOnly = true;
			
			this.networkJobServer.EnqueueJob(
				delegate(object arg){
					this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
						this.outputs.Add(new MessageOutputItem("Xe[^XM..."));
					}));
					return TwitterAPI.UpdateStatus(this.currentAccount, status, 0, "Hiyoko");
				},
				this.WriteRequestDataCallback,
				delegate(NetworkJobData data){
					try{
						using(HttpWebResponse res = (HttpWebResponse)data.WebRequestData.WebRequest.EndGetResponse(data.AsyncResult)){
							this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
								this.outputs.Add(new SuccessOutputItem("Xe[^XM"));
								this.statusEdit.Text = "";
							}));
						}
					}catch(WebException ex){
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
						}));
					}
				},
				delegate{
					V(this.updateStatusSemaphore);
					this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
						this.statusEdit.IsReadOnly = false;
					}));
				}
			);
		}
		
		private void DestroyStatus(IEnumerable<Status> statuses){
			foreach(Status stat in statuses){
				Status status = stat;
				this.networkJobServer.EnqueueJob(
					delegate{
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new MessageOutputItem("Xe[^X폜..."));
						}));
						return TwitterAPI.DestroyStatus(this.currentAccount, status.Id);
					},
					this.WriteRequestDataCallback,
					delegate(NetworkJobData data){
						try{
							using(HttpWebResponse res = (HttpWebResponse)data.WebRequestData.WebRequest.EndGetResponse(data.AsyncResult)){
								this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
									this.outputs.Add(new SuccessOutputItem("Xe[^X폜"));
								}));
							}
						}catch(WebException ex){
							this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
								this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
							}));
						}
					}
				);
			}
		}
		
		private void DestroyFriendship(IEnumerable<Status> statuses){
			foreach(Status stat in statuses){
				Status status = stat;
				this.networkJobServer.EnqueueJob(
					delegate{
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new MessageOutputItem("tH[폜..."));
						}));
						return TwitterAPI.DestroyFriendship(this.currentAccount, status.Id);
					},
					this.WriteRequestDataCallback,
					delegate(NetworkJobData data){
						try{
							using(HttpWebResponse res = (HttpWebResponse)data.WebRequestData.WebRequest.EndGetResponse(data.AsyncResult)){
								this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
									this.outputs.Add(new SuccessOutputItem("tH[폜"));
								}));
							}
						}catch(WebException ex){
							this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
								this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
							}));
						}
					}
				);
			}
		}
		
		private void CreateFavorite(IEnumerable<Status> statuses){
			foreach(Status stat in statuses){
				Status status = stat;
				this.networkJobServer.EnqueueJob(
					delegate{
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new MessageOutputItem("Cɓǉ..."));
						}));
						return TwitterAPI.CreateFavorite(this.currentAccount, status.Id);
					},
					this.WriteRequestDataCallback,
					delegate(NetworkJobData data){
						try{
							using(HttpWebResponse res = (HttpWebResponse)data.WebRequestData.WebRequest.EndGetResponse(data.AsyncResult)){
								this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
									this.outputs.Add(new SuccessOutputItem("Cɓǉ"));
								}));
							}
						}catch(WebException ex){
							this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
								this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
							}));
						}
					}
				);
			}
		}
		
		private void CreateBlock(IEnumerable<Status> statuses){
			foreach(Status stat in statuses){
				Status status = stat;
				this.networkJobServer.EnqueueJob(
					delegate{
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new MessageOutputItem("ubNǉ..."));
						}));
						return TwitterAPI.CreateBlock(this.currentAccount, status.Id);
					},
					this.WriteRequestDataCallback,
					delegate(NetworkJobData data){
						try{
							using(HttpWebResponse res = (HttpWebResponse)data.WebRequestData.WebRequest.EndGetResponse(data.AsyncResult)){
								this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
									this.outputs.Add(new SuccessOutputItem("ubNǉ"));
								}));
							}
						}catch(WebException ex){
							this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
								this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
							}));
						}
					}
				);
			}
		}
		
		private void ShortenUrlStatusEdit(){
			UrlShorter urlShorter = this.urlShorter;
			if(urlShorter == null){
				throw new InvalidOperationException();
			}
			
			string status = this.StatusEdit.Text;
			this.StatusEdit.IsReadOnly = true;
			
			P(this.shortenUrlStatusEditSemaphore);
			ThreadPool.QueueUserWorkItem(new WaitCallback(delegate{
				string shortStatus = StringEx.UrlRegex.Replace(status, new MatchEvaluator(delegate(Match match){
					string shortUrl = null;
					ManualResetEvent wait = new ManualResetEvent(false);
					this.networkJobServer.EnqueueJob(
						delegate{
							this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
								this.outputs.Add(new MessageOutputItem("ZkURL擾..."));
							}));
							return urlShorter.RequireShorten(match.Value);
						},
						null,
						delegate(NetworkJobData data){
							try{
								using(HttpWebResponse res = (HttpWebResponse)data.WebRequestData.WebRequest.EndGetResponse(data.AsyncResult)){
									shortUrl = urlShorter.Shorten(res);
								}
								this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
									this.outputs.Add(new SuccessOutputItem("ZkURL擾"));
								}));
							}catch(WebException ex){
								this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
									this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
								}));
							}
						},
						delegate{
							wait.Set();
						}
					);
					wait.WaitOne();
					return shortUrl;
				}));
				this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
					this.statusEdit.Text = shortStatus;
					this.statusEdit.IsReadOnly = false;
				}));
				V(this.shortenUrlStatusEditSemaphore);
			}));
		}
		
		private void UploadImage(string filename, Action<string> callback){
			WebUploader uploader = new Twitpic(Program.Settings.TwitpicUsername, Program.Settings.TwitpicPassword);
			P(this.uploadImageSemaphore);
			this.networkJobServer.EnqueueJob(
				delegate{
					try{
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new MessageOutputItem("摜Abv[h..."));
						}));
						return uploader.RequestUpload(filename);
					}catch(Exception ex){
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new ErrorOutputItem(ex.Message));
							if(callback != null){
								callback(null);
							}
						}));
					}
					return null;
				},
				this.WriteRequestDataCallback,
				delegate(NetworkJobData data){
					try{
						string url = null;
						using(HttpWebResponse res = (HttpWebResponse)data.WebRequestData.WebRequest.EndGetResponse(data.AsyncResult)){
							url = uploader.Upload(res);
						}
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							if(callback != null){
								callback(url);
							}
							if(url != null){
								this.outputs.Add(new SuccessOutputItem("摜Abv[h"));
							}else{
								this.outputs.Add(new ErrorOutputItem("摜Abv[hs"));
							}
						}));
					}catch(WebException ex){
						this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
							this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
						}));
					}
				},
				delegate{
					V(this.uploadImageSemaphore);
				}
			);
		}
		
		/// <summery>
		/// Xe[^XԂ̓e̍̉dςC^[ovZB
		/// </summery>
		private void CalculateAutoRefreshTimelineInterval(){
			TimeSpan span = TimeSpan.FromSeconds(60);
			if(this.timeline.Count > 1){
				double a = 1 - this.autoRefreshTimelineWeight;
				double w = 1;
				double wsum = 0;
				decimal sum = 0;
				DateTime[] times = (this.CurrentTimelinePage == 1) ? (new DateTime[]{DateTime.Now}).Concat(this.timeline.Select(s => s.CreatedAt)).ToArray() :
				                                                     this.timeline.Select(s => s.CreatedAt).ToArray();
				for(int i = 1; i < times.Length; i++, w *= a){
					TimeSpan t = times[i - 1] - times[i];
					sum += (decimal)(t.TotalSeconds * w);
					wsum += w;
				}
				sum /= (decimal)wsum;
				sum /= 2;
				if(sum > 60){
					span = TimeSpan.FromSeconds((double)sum);
				}
			}
			this.autoRefreshTimelineTimer.Stop();
			this.autoRefreshTimelineTimer.Interval = span;
			this.autoRefreshTimelineTimer.Start();
		}
		
		private void WriteRequestDataCallback(NetworkJobData data){
			try{
				using(Stream stream = data.WebRequestData.WebRequest.EndGetRequestStream(data.AsyncResult)){
					data.WebRequestData.WriteRequestData(stream);
				}
			}catch(WebException ex){
				this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
					this.outputs.Add(new ErrorOutputItem(String.Format("{0} :{1}", (int)ex.Status, ex.Message)));
				}));
			}
		}
		
		#endregion
		
		#region Xe[^X
		
		private void StatusEdit_TextChanged(object sender, TextChangedEventArgs e){
			this.RefreshStatusEditCount();
		}
		
		private void RefreshStatusEditCount(){
			int count = this.statusEdit.Text.Length;
			int dispCount = 140 - count;
			if(dispCount < 10){
				this.statusEditCount.Foreground = (SolidColorBrush)this.Resources["statusEditCountHighWarningColor"];
			}else if(dispCount < 20){
				this.statusEditCount.Foreground = (SolidColorBrush)this.Resources["statusEditCountWarningColor"];
			}else{
				this.statusEditCount.Foreground = (SolidColorBrush)this.Resources["statusEditCountNormalColor"];
			}
			this.statusEditCount.Content = dispCount.ToString().PadLeft(3);
		}
		
		#endregion
		
		#region AEgvbg
		
		private void Outputs_CollectionChanged(object sender, NotifyCollectionChangedEventArgs e){
			this.outputList.Dispatcher.BeginInvoke(DispatcherPriority.Render, new Action(delegate{
				if(this.outputs.Count > Program.Settings.OutputItemLimitCount){
					this.outputs.CollectionChanged -= this.Outputs_CollectionChanged;
					for(int i = Program.Settings.OutputItemLimitCount; i <= this.outputs.Count; i++){
						this.outputs.RemoveAt(0);
					}
					this.outputs.CollectionChanged += this.Outputs_CollectionChanged;
				}
				if(this.outputList.HasItems){
					this.outputList.ScrollIntoView(this.outputList.Items[this.outputList.Items.Count - 1]);
				}
			}));
		}
		
		public Collection<OutputItem> Outputs{
			get{
				return this.outputs;
			}
		}
		
		#endregion
		
		#region Z}tH
		
		private static bool IsAvailable(Semaphore sem){
			bool signal = sem.WaitOne(0, false);
			if(signal){
				sem.Release();
			}
			return signal;
		}
		
		private static void P(Semaphore sem){
			sem.WaitOne();
			Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.SystemIdle, new Action(delegate{
				CommandManager.InvalidateRequerySuggested();
			}));
		}
		
		private static void V(Semaphore sem){
			sem.Release();
			Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.SystemIdle, new Action(delegate{
				CommandManager.InvalidateRequerySuggested();
			}));
		}
		
		#endregion
		
		#region ̑
		
		public static ScrollViewer GetScrollViewer(DependencyObject dobj){
			if(dobj is ScrollViewer){
				return dobj as ScrollViewer;
			}
			int count = VisualTreeHelper.GetChildrenCount(dobj);
			for(int i = 0; i < count; i++){
				var ret = GetScrollViewer(VisualTreeHelper.GetChild(dobj, i));
				if(ret != null){
					return ret;
				}
			}
			return null;
		}
		
		#endregion
		
		#region Debug
		
		private class OutputPanelTraceListener : TraceListener{
			private MainForm mainForm;
			
			public OutputPanelTraceListener(MainForm mainForm) : base(){
				this.mainForm = mainForm;
			}
			
			private void _Write(string message){
				if(this.NeedIndent){
					this.WriteIndent();
				}
				if(this.mainForm.Outputs.Count > 0){
					OutputItem item = this.mainForm.Outputs[this.mainForm.Outputs.Count - 1];
					item.Text += message;
					item.DateTime = DateTime.Now;
				}else{
					this.mainForm.Outputs.Add(new MessageOutputItem(message));
				}
			}
			
			private void _WriteLine(string message){
				if(this.NeedIndent){
					this.WriteIndent();
				}
				this.mainForm.Outputs.Add(new MessageOutputItem(message));
			}
			
			public override void Write(object o){
				this._Write(o.ToString());
			}
			
			public override void Write(string message){
				this._Write(message);
			}
			
			public override void Write(object o, string category){
				this._Write(category + " : " + o.ToString());
			}
			
			public override void Write(string message, string category){
				this._Write(category + " : " + message);
			}
			
			public override void WriteLine(object o){
				this._Write(o.ToString());
			}
			
			public override void WriteLine(string message){
				this._WriteLine(message);
			}
			
			public override void WriteLine(object o, string category){
				this._WriteLine(category + " : " + o.ToString());
			}
			
			public override void WriteLine(string message, string category){
				this._WriteLine(category + " : " + message);
			}
		}
		
		#endregion
		
		#region vpeB
		
		public Collection<Status> Timeline{
			get{
				return this.timeline;
			}
		}
		
		public ListBox TimelineList{
			get{
				return this.timelineList;
			}
		}
		
		public TabItem TimelineTabItem{
			get{
				return this.timelineTabItem;
			}
		}
		
		public XElement TimelineXml{
			get{
				return this.timelineXml;
			}
		}
		
		public TextBox StatusEdit{
			get{
				return this.statusEdit;
			}
		}
		
		public NetworkJobServer NetworkJobServer{
			get{
				return this.networkJobServer;
			}
		}
		
		public UrlShorter UrlShorter{
			get{
				return this.urlShorter;
			}
		}
		
		public static readonly DependencyProperty CurrentTimelinePageProperty = DependencyProperty.Register("CurrentTimelinePage", typeof(int), typeof(MainForm));
		public int CurrentTimelinePage{
			get{
				return (int)this.GetValue(CurrentTimelinePageProperty);
			}
			set{
				if(value <= 0){
					throw new ArgumentOutOfRangeException();
				}
				this.SetValue(CurrentTimelinePageProperty, value);
			}
		}
		
		public HotKeyManager HotKeyManager{
			get{
				return this.hotKeyManager;
			}
		}
		
		#endregion
	}
}