/*
	$Id: Status.cs 6 2009-12-26 00:58:57Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;

namespace Hiyoko.Twitter{
	public class Status{
		public DateTime CreatedAt{get; private set;}
		public decimal Id{get; private set;}
		public string Text{get; private set;}
		public string Source{get; private set;}
		public bool Trancated{get; private set;}
		public decimal InReplyToStatusId{get; private set;}
		public decimal InReplyToUserId{get; private set;}
		public bool Favorited{get; private set;}
		public string InReplyToScreenName{get; private set;}
		public User User{get; private set;}
		
		public Status(XElement status){
			DateTime dt;
			if(TwitterAPI.TryParseDateTime((string)status.Element("created_at"), out dt)){
				this.CreatedAt = dt;
			}
			this.Id = (decimal)status.Element("id");
			this.Text = HttpUtility.UrlDecode((string)status.Element("text"), Encoding.UTF8);
			this.Source = HttpUtility.HtmlDecode((string)status.Element("source"));
			this.Trancated = (bool)status.Element("truncated");
			decimal dec;
			if(Decimal.TryParse((string)status.Element("in_reply_to_status_id"), out dec)){
				this.InReplyToStatusId = dec;
			}
			if(Decimal.TryParse((string)status.Element("in_reply_to_user_id"), out dec)){
				this.InReplyToUserId = dec;
			}
			this.InReplyToScreenName = (string)status.Element("in_reply_to_screen_name");
			this.Favorited = (bool)status.Element("favorited");
			
			this.User = new User(status.Element("user"));
		}
		
		public override bool Equals(object obj){
			Status status = obj as Status;
			if(status != null){
				return this.Id.Equals(status.Id);
			}else{
				return false;
			}
		}
		
		public override int GetHashCode(){
			return this.Id.GetHashCode();
		}
	}
}