<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once(dirname(__FILE__) . "/common/common.php");
	require_once(dirname(__FILE__) . "/logic/Hirameki_ArticleLogic.php");
	
	if (isset($_POST["title"])) {
		$message = array();
		
		if (empty($_POST["content"])) {
			$message[] = "内容を入力してください。";
		}
		
		if (count($message) === 0) {
			$id = Hirameki_ArticleLogic::create(1, $_POST["title"], $_POST["content"], $_POST["tag"]);
			
			require_once("article_create_complete.php");
			exit;
		}
	}
	
	Hirameki_HtmlUtil::headerContentType();
	
	$page_title = "記事の登録";
	require_once("page_header.php");
?>
<?php
	if (isset($message)) {
?>
		<div id="message">
			<ul>
<?php
	foreach ($message as $m) {
?>
				<li><?php Hirameki_HtmlUtil::printStr($m); ?></li>
<?php
	}
?>
			</ul>
		</div>
<?php
	}
?>
		<form action="article_create.php" method="post">
			<table id="input_form">
				<tr>
					<th>件名</th>
					<td><input type="text" name="title"<?php if (isset($_POST["title"])) { ?> value="<?php print($_POST["title"]); ?>"<?php } ?>></input></td>
				</tr>
				<tr>
					<th>内容</th>
					<td><textarea name="content" rows="5" cols="60"><?php if (isset($_POST["content"])) { print($_POST["content"]); } ?></textarea></td>
				</tr>
				<tr>
					<th>タグ</th>
					<td><input type="text" name="tag"<?php if (isset($_POST["tag"])) { ?> value="<?php print($_POST["tag"]); ?>"<?php } ?>></input></td>
				</tr>
				<tr>
					<th></th>
					<td><input type="submit" value="登録"></input></td>
				</tr>
			</table>
		</form>
<?php
	require_once("page_footer.php");
?>
