package hayashi.yuu.tools.gui;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

@SuppressWarnings("serial")
public class QuitDialog extends JDialog implements WindowListener
{
    JButton yesButton;
    JButton noButton;
    JLabel label1;

    public QuitDialog(JFrame parent, boolean modal) {
        super(parent, modal);
        addWindowListener((WindowListener) this);
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        setLayout(null);
        setSize(getInsets().left + getInsets().right + 337, getInsets().top + getInsets().bottom + 135);
        
        yesButton = new JButton("  終了  ");
        yesButton.addActionListener(new java.awt.event.ActionListener() {
        	public void actionPerformed(java.awt.event.ActionEvent evt) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((Window)getParent(), 201));
                System.exit(0);
        	}
        });
        yesButton.setBounds(getInsets().left + 72, getInsets().top + 80, 79, 22);
        yesButton.setFont(new Font("Dialog", 1, 12));
        add(yesButton);

        noButton = new JButton("キャンセル");
        noButton.addActionListener(new java.awt.event.ActionListener() {
        	public void actionPerformed(java.awt.event.ActionEvent evt) {
        		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(QuitDialog.this, WindowEvent.WINDOW_CLOSING));
        		setVisible(false);
        	}
        });
        noButton.setBounds(getInsets().left + 185, getInsets().top + 80, 99, 22);
        noButton.setFont(new Font("Dialog", 1, 12));
        add(noButton);
        
        label1 = new JLabel("プログラムを終了します。", JLabel.CENTER);
        label1.setBounds(78, 33, 180, 23);
        add(label1);
        setTitle("プログラムの終了");
        setResizable(false);
        setVisible(true);
    }

    public void setVisible(boolean b) {
        if(b) {
            Rectangle bounds = getParent().getBounds();
            Rectangle abounds = getBounds();
            setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        }
        super.setVisible(b);
    }


	public void windowActivated(WindowEvent e) {
	}

	public void windowClosed(WindowEvent e) {
		setVisible(false);
	}

	public void windowClosing(WindowEvent e) {
		setVisible(false);
	}

	public void windowDeactivated(WindowEvent e) {
	}

	public void windowDeiconified(WindowEvent e) {
	}

	public void windowIconified(WindowEvent e) {
	}

	public void windowOpened(WindowEvent e) {
	}
}
