# -*- mode: perl; coding: utf-8 -*-
# $Id: 02_Plugins.t,v 1.3 2008-08-05 14:08:25 morimoto Exp $
# $Source: /home/ishikawa/tmp/TEST/CVS/keitairc/t/02_Plugins.t,v $
# Copyright (c) 2003-2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2
use strict;
use warnings;
use Test::More tests => 6;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
	use_ok('Keitairc::Plugins');
}

can_ok('Keitairc::Plugins',
       qw/new list_plugins list_replace_plugins list_action_plugins
       load_plugins/);

use Keitairc::Config;
use Keitairc::Log;

my $cf = new Keitairc::Config({
	version => '0.0',
	silent => 1,
	argv => [
		'-web_host', 'example.com',
		'-irc_nick', 'foo',
		'-irc_username', 'foo',
		'-irc_server', 'example.com',
		'-web_password', 'foo',
		'-plugin_dir', "$FindBin::Bin/02_Plugins"
		]});
my $pl = new Keitairc::Plugins({config => $cf, silent => 1});
ok($pl, 'new Keitairc::Plugins');

ok(array_eq($pl->list_plugins(),
	    qw/unread index topic recent mail foo bar/),
   'list_plugins()');
ok(array_eq($pl->list_replace_plugins(),
	    qw/mail foo bar/),
   'list_replace_plugins()');
ok(array_eq($pl->list_action_plugins(),
	    qw/unread index topic recent mail foo bar/),
   'list_action_plugins()');
exit;

sub array_eq{
	if(@_ % 2){
		return 0;
	}

	for(my($a, $b) = (0, @_/2); $a < @_/2; $a++, $b++){
		return 0 unless $_[$a] eq $_[$b];
	}
	1;
}


