/*
 -*- mode: javascript; coding: utf-8 -*-
 $Id: geopost-keitairc.js,v 1.4 2009-07-15 11:42:44 ishikawa Exp $

 Copyright (c) 2009 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
 This program is covered by the GNU General Public License 2
*/

/*
keitairc_post_url: 発言POST先のURL
keitairc_stamp: 発言のタイムスタンプ
keitairc_channel: チャネル名

をあらかじめ外部でセットしておく必要があります。

上記はkeitairc都合な都合で表示メッセージを組み立てるのに必要
(msg を組み立ててるところだけに使われてる)なだけで、それ以外は
だいぶ generic に作ってある(keitairc 都合な部分はそこのみ)なつもり。

現在位置を測位して <div id="map_canvas"></div> にその位置が中心に
なった google map が表示されます。

google map api 使ってるので <head> とかで

<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=true"></script>

も必要です。
*/

addEventListener("load", function(event) {
	navigator.geolocation.getCurrentPosition(function (position) {
		var latLng = new google.maps.LatLng(position.coords.latitude,
						position.coords.longitude);

		var map = new google.maps.Map(document.getElementById("map_canvas"),
					      {zoom: 15,
					       mapTypeId: google.maps.MapTypeId.ROADMAP,
					       center: latLng});

		var marker = new google.maps.Marker({map: map,
						     position: latLng});

		var geocoder = new google.maps.Geocoder();
		geocoder.geocode({'latLng': latLng}, function(results, status) {
			if (status == google.maps.GeocoderStatus.OK) {
				var Address = '現在の地名が分かりません: 北緯 = ' + position.coords.latitude + ', 東経 = ' + position.coords.longitude;
				for(var i = 1; i < results.length; i++){
					if (results[i].types.length >= 2 && results[i].types[1] == "political") {
						Address = results[i].formatted_address.replace(/^日本/, '');
						break;
					}
				}

				var msg;
				msg = '<span style="font-size:80%">';
				msg += '<strong>現在の場所:</strong><br />';
				msg += Address;
				msg += '</span><hr />';
				msg += '<form action="'+keitairc_post_url+'" method="post">';
				msg += '<input type="hidden" name="m" value="現在位置: L:'+ Address + '" />';
				msg += '<input type="hidden" name="stamp" value="'+keitairc_stamp+'" />';
				msg += '<button type="submit" href="#">'+keitairc_channel+'へ発言</button>';
				msg += '</form>';
				var info = new google.maps.InfoWindow({content: msg});
				info.open(map, marker);
			} else {
				alert("地名の変換に失敗しました: エラーコード = " + status);
			}
		});
	});
}, true)

