/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: StdoutView.cpp 49 2011-05-16 15:07:54Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#include "spcf/view/StdoutView.hpp"

#include "spcf/core/Recognition.hpp"
#include "spcf/core/RecognitionProperty.hpp"

#include <iostream>
using namespace std;

namespace spcf {

	void StdoutView::start(Context& context) {
		cout << "start" << endl;
	}

	void StdoutView::soundStarted(Context& context) {
		cout << "soundStarted" << endl;
	}

	void StdoutView::soundStoped(Context& context) {
		cout << "soundStoped" << endl;
	}

	void StdoutView::recognized(Context& context, Recognition& recognition) {
		cout << "recognized:" << recognition.getText() << "," << recognition.getGrammarName() << endl;
		for (RecognitionPropertyIterator i = recognition.beginProperty(); i != recognition.endProperty(); ++i) {
			const RecognitionPropertyPtr& property = *i;
			cout << property->getName();
			if (property->hasInt()) {
				cout << ":int(" << property->getInt() << ")";
			}
			if (property->hasString()) {
				cout << ":string(" << property->getString() << ")";
			}
			cout << endl;
		}
	}

	void StdoutView::stop(Context& context) {
		cout << "stop" << endl;
	}

	void StdoutView::finish(Context& context) {
		cout << "finish" << endl;
	}

}  // namespace spcf
