/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: SAPIRecognitionProperty.cpp 26 2011-05-10 12:09:48Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "spcf/sapi/SAPIRecognitionProperty.hpp"

#include "spcf/sapi/utils/WChar2Char.hpp"

using namespace std;

namespace spcf {

	class SAPIRecognitionProperty_i {
	public:
		string name_;
		bool hasVal_;
		int val_;
		bool hasValStr_;
		string valStr_;
	};

	SAPIRecognitionProperty::SAPIRecognitionProperty(const SPPHRASEPROPERTY* property) : impl(new SAPIRecognitionProperty_i()) {
		impl->name_ = WChar2Char(property->pszName);
		// VAL̒l擾
		switch (V_VT(&property->vValue)) {
		case VT_I4:
			impl->hasVal_ = true;
			impl->val_ = V_I4 (&property->vValue);
			break;
		case VT_UI4:
			impl->hasVal_ = true;
			impl->val_ = V_UI4(&property->vValue);
			break;
		default:
			impl->hasVal_ = false;
			break;
		}

		// VALSTR̒l擾
		if (impl->hasValStr_ = (0 != property->pszValue)) {
			impl->valStr_ = WChar2Char(property->pszValue);
		}
	}

	SAPIRecognitionProperty::~SAPIRecognitionProperty() {
		delete impl;
	}

	const string& SAPIRecognitionProperty::getName() const {
		return impl->name_;
	}

	bool SAPIRecognitionProperty::hasInt() const {
		return impl->hasVal_;
	}

	const int& SAPIRecognitionProperty::getInt() const {
		return impl->val_;
	}

	bool SAPIRecognitionProperty::hasString() const {
		return impl->hasValStr_;
	}

	const string& SAPIRecognitionProperty::getString() const {
		return impl->valStr_;
	}

}  // namespace spcf
