/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ChainProcessor.hpp 37 2011-05-12 03:56:33Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_PROCESSOR_CHAIN_PROCESSOR_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_PROCESSOR_CHAIN_PROCESSOR_HPP_

#include "spcf/core/Processor.hpp"

#include <boost/shared_ptr.hpp>

namespace spcf {

	typedef boost::shared_ptr<Processor> ProcessorPtr;

	class ChainProcessor_i;

	class ChainProcessor : public Processor {
	private:
		ChainProcessor_i* impl;

	public:
		ChainProcessor();
		virtual ~ChainProcessor();

	public:
		void addProcessor(const ProcessorPtr& processor);

	public:
		void start(Context& context);
		void soundStarted(Context& context);
		void soundStoped(Context& context);
		void recognized(Context& context, Recognition& recognition);
		void stop(Context& context);
		void finish(Context& context);
	};

}  // namespace spcf

#endif
