/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: NumeralGrammar.cpp 52 2011-05-17 06:24:31Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "spcf/grammar/NumeralGrammar.hpp"

#include "spcf/core/GrammarPhrase.hpp"
#include "spcf/core/GrammarTransition.hpp"

using namespace std;

namespace spcf {

	void setGrammar(NumeralGrammar& self, unsigned int style, const string* propertyName);

	NumeralGrammar::NumeralGrammar(const string& name, unsigned int style) : GrammarCommonImpl(name) {
		setGrammar(*this, style, 0);
	}

	NumeralGrammar::NumeralGrammar(const string& name, unsigned int style, const string& propertyName) : GrammarCommonImpl(name) {
		setGrammar(*this, style, &propertyName);
	}

	NumeralGrammar::~NumeralGrammar() {
	}

	void setGrammar(NumeralGrammar& grammar, unsigned int style, const string* propertyName) {
		GrammarTransitionPtr t0 = grammar.addGrammarTransition("", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t1 = grammar.addGrammarTransition("", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t2 = grammar.addGrammarTransition("Ɂ[", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t3 = grammar.addGrammarTransition("", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t4 = grammar.addGrammarTransition("[", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t5 = grammar.addGrammarTransition("[", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t6 = grammar.addGrammarTransition("낭", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t7 = grammar.addGrammarTransition("Ȃ", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t8 = grammar.addGrammarTransition("͂", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		GrammarTransitionPtr t9 = grammar.addGrammarTransition("[", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
		if (propertyName) {
			t0->getPhrase()->setProperty(*propertyName, 0, "0");
			t1->getPhrase()->setProperty(*propertyName, 1, "1");
			t2->getPhrase()->setProperty(*propertyName, 2, "2");
			t3->getPhrase()->setProperty(*propertyName, 3, "3");
			t4->getPhrase()->setProperty(*propertyName, 4, "4");
			t5->getPhrase()->setProperty(*propertyName, 5, "5");
			t6->getPhrase()->setProperty(*propertyName, 6, "6");
			t7->getPhrase()->setProperty(*propertyName, 7, "7");
			t8->getPhrase()->setProperty(*propertyName, 8, "8");
			t9->getPhrase()->setProperty(*propertyName, 9, "9");
		}
	}

}  // namespace spcf
