/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: GrammarPhrase.cpp 52 2011-05-17 06:24:31Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#include "spcf/core/GrammarPhrase.hpp"

namespace spcf {

	using namespace std;

	class GrammarPhrase_i {
	public:
		string phrase_;
		string* propertyName_;
		int* propertyInt_;
		string* propertyString_;

		GrammarPhrase_i(const string& phrase, string* propertyName, int* propertyInt, string* propertyString) :
				phrase_(phrase), propertyName_(propertyName), propertyInt_(propertyInt), propertyString_(propertyString) {
		}

		~GrammarPhrase_i() {
			clearProperty();
		}

	public:
		void clearProperty() {
			if (!propertyName_ != 0) {
				delete propertyName_;
			}

			if (!propertyInt_ != 0) {
				delete propertyInt_;
			}

			if (!propertyString_ != 0) {
				delete propertyString_;
			}
		}
	};

	GrammarPhrase::GrammarPhrase(const string& phrase) :
			impl(new GrammarPhrase_i(phrase, 0, 0, 0)) {
	}

	GrammarPhrase::GrammarPhrase(const string& phrase, const string& propertyName) :
			impl(new GrammarPhrase_i(phrase, new string(propertyName), 0, 0)) {
	}

	GrammarPhrase::GrammarPhrase(const string& phrase, const string& propertyName, int propertyInt) :
			impl(new GrammarPhrase_i(phrase, new string(propertyName), new int(propertyInt), 0)) {
	}

	GrammarPhrase::GrammarPhrase(const string& phrase, const string& propertyName, const string& propertyString) :
			impl(new GrammarPhrase_i(phrase, new string(propertyName), 0, new string(propertyString))) {
	}

	GrammarPhrase::GrammarPhrase(const string& name, const string& propertyName, int propertyInt, const string& propertyString) :
			impl(new GrammarPhrase_i(name, new string(propertyName), new int(propertyInt), new string(propertyString))) {
	}

	GrammarPhrase::~GrammarPhrase() {
		delete impl;
	}

	const string& GrammarPhrase::getPhrase() const {
		return impl->phrase_;
	}

	bool GrammarPhrase::hasProperty() const {
		return impl->propertyName_ != 0;
	}

	const string& GrammarPhrase::getPropertyName() const {
		return *impl->propertyName_;
	}

	bool GrammarPhrase::hasPropertyInt() const {
		return impl->propertyInt_ != 0;
	}

	const int& GrammarPhrase::getPropertyInt() const {
		return *impl->propertyInt_;
	}

	bool GrammarPhrase::hasPropertyString() const {
		return impl->propertyString_ != 0;
	}

	const string& GrammarPhrase::getPropertyString() const {
		return *impl->propertyString_;
	}

	void GrammarPhrase::setProperty(const string& propertyName) {
		impl->clearProperty();
		impl->propertyName_ = new string(propertyName);
	}

	void GrammarPhrase::setProperty(const string& propertyName, int propertyInt) {
		impl->clearProperty();
		impl->propertyName_ = new string(propertyName);
		impl->propertyInt_ = new int(propertyInt);
	}

	void GrammarPhrase::setProperty(const string& propertyName, const string& propertyString) {
		impl->clearProperty();
		impl->propertyName_ = new string(propertyName);
		impl->propertyString_ = new string(propertyString);
	}

	void GrammarPhrase::setProperty(const string& propertyName, int propertyInt, const string& propertyString) {
		impl->clearProperty();
		impl->propertyName_ = new string(propertyName);
		impl->propertyInt_ = new int(propertyInt);
		impl->propertyString_ = new string(propertyString);
	}

	void GrammarPhrase::clearProperty() {
		impl->clearProperty();
	}

}  // namespace spcf
