#ifndef BOARD_H
#define BOARD_H

//----------------------------------------------------------------------
//
//			File:			"Board.h"
//			Created:		26-Aug-2012
//			Author:			Nobuhide Tsuda
//			Description:	{[hNX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	HalfGammon ̃CZX CDDL 1.0 łB
	http://opensource.org/licenses/cddl-1.0
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	\[XR[h𗬗pꍇApt@C̃CZX CDDL 1.0 ƂȂ܂B
	p̒쌠 HalfGammon ̂̂܂܂łB
	҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	CDDL 1.0 I܂B̃CZXGPLnėp₷AGPLnƂ͖郉CZXȂ̂ŁA
	HalfGammon ̃\[XGPLnvWFNgŎgp邱Ƃ͂ł܂B

*/

#include <QList>
#include <QByteArray>

typedef quint64 uint64;
typedef const char cchar;
typedef unsigned char uchar;

#define		PACKED		0		//	1 for zł͂Ȃ uint64 gp

#if	PACKED
inline int		shift(int ix) { return ix * 4; }
inline uint64	one(int ix) { return (uint64)1 << shift(ix); }
inline uint64	mask(int ix) { return (uint64)0x0f << shift(ix); }
#endif

enum {
	N_PIECE = 8,			//	̐ΐ
	N_DICE = 3,				//	TCR̖ڂ̏
	N_POINT = N_DICE * 4,
	SIZE_S_POINTS_G = N_POINT + 2,		//	2 for Start/Goal
	POINT_START = SIZE_S_POINTS_G - 1,		//	StartGoal ŃCfbNX͌
	POINT_GOAL = 0,
	IX_START = SIZE_S_POINTS_G - 1,		//	StartGoal ŃCfbNX͌Ȁꍇ POINTԍƈv
	IX_GOAL = 0,

	LEVEL_RANDOM = 0,		//	S_
	LEVEL_BEGINNER,			//	F_/]֐{1ǂ
	LEVEL_INTERMEDIATE,		//	F]֐ eval5 {1ǂ
	LEVEL_ADVANCED,			//	㋉F]֐ eval5 {3ǂ
};
inline int reverseIX(int ix) { return IX_START - ix; }
inline int pointToBlackIndex(int p) { return p; }				//	̓|CgCfbNX
inline int blackIndexToPoint(int ix) { return ix; }
inline int pointToWhiteIndex(int p) { return reverseIX(p); }	//	͍E]
inline int whiteIndexToPoint(int ix) { return reverseIX(ix); }

//	̈ړ
struct Move
{
	uchar	m_src;
	uchar	m_d;

public:
	Move(uchar src = 0, uchar d = 0)
		: m_src(src)
		, m_d(d)
	{
		Q_ASSERT( src <= IX_START );
		Q_ASSERT( src > IX_GOAL );
	}
	bool	isValid() const { return m_d != 0; }
};

typedef QList<Move> Moves;

class Board
{
public:
	Board();
	Board(const Board &);
	Board(cchar *);
#if		PACKED
	Board(uint64 black, uint64 white) : m_black(black), m_white(white) {}
#endif
	~Board() {};

public:
	Board	&operator=(const Board &);
	bool	operator==(const Board &) const;

public:
	QByteArray	hashKey() const;
	bool	doesBlackWin() const { return black(IX_GOAL) == N_PIECE; }
	bool	doesWhiteWin() const { return white(IX_GOAL) == N_PIECE; }
#if PACKED
	bool	doesBlackGammonLose() const { return (m_black & 0xffffffffff0000) != 0; }
	bool	doesWhiteGammonLose() const { return (m_white & 0xffffffffff0000) != 0; }
	bool	doesBlackBackGammonLose() const { return (m_black & 0xffff0000000000) != 0; }
	bool	doesWhiteBackGammonLose() const { return (m_white & 0xffff0000000000) != 0; }
	uint64	black() const { return m_black; }
	uint64	white() const { return m_white; }
	int		black(int ix) const { return (m_black >> shift(ix)) & 0x0f; }
	int		white(int ix) const { return (m_white >> shift(ix)) & 0x0f; }
#else
	bool	doesBlackGammonLose() const { return blackTailIndex() > N_DICE; }
	bool	doesWhiteGammonLose() const { return whiteTailIndex() > N_DICE; }
	bool	doesBlackBackGammonLose() const { return blackTailIndex() >= IX_START - N_DICE; }
	bool	doesWhiteBackGammonLose() const { return whiteTailIndex() >= IX_START - N_DICE; }
	int		black(int ix) const { return m_black[ix]; }
	int		white(int ix) const { return m_white[ix]; }
#endif
	char	position(int pnt) const { return black(pointToBlackIndex(pnt))
												? black(pointToBlackIndex(pnt))
												: -white(pointToWhiteIndex(pnt)); }
	QString	position() const;
	int		nBlackGoal() const { return black(IX_GOAL); }
	int		nWhiteGoal() const { return white(IX_GOAL); }
	int		nBlackBar() const { return black(IX_START); }
	int		nWhiteBar() const { return white(IX_START); }
#if		PACKED
	bool	canBlackBearOff() const { return !(m_black & 0xffffffffff0000); }
	bool	canWhiteBearOff() const { return !(m_white & 0xffffffffff0000); }
#else
	bool	canBlackBearOff() const;
	bool	canWhiteBearOff() const;
#endif
	int		blackTailIndex() const;
	int		whiteTailIndex() const;
	bool	canBlackMoveSrcDst(int, int) const;
	bool	canWhiteMoveSrcDst(int, int) const;
	Moves	blackMoves(int d1) const;		//	w_CX̖ڂŉ\ȒXgAbv
	Moves	whiteMoves(int d1) const;		//	w_CX̖ڂŉ\ȒXgAbv
	Moves	blackMoves(int d1, int d2) const;		//	w_CX̖ڂŉ\ȒXgAbv
	Moves	whiteMoves(int d1, int d2) const;		//	w_CX̖ڂŉ\ȒXgAbv
	QList<Moves>	blackMovesList(int d1, int d2) const;
	QList<Moves>	whiteMovesList(int d1, int d2) const;
	QList<Moves>	whiteMovesList2(int d1, int d2) const;
	int		eval5() const;		//	sbvXCɂ]֐
	Moves	whiteMovesEval5PlyD(int depth, int d1, int d2, double &) const;	//	]֐{depthǂ݂ɂ蒅
	Moves	whiteMovesRandom(int d1, int d2) const;		//	_ɒI
	Moves	blackMoves(int level, int d1, int d2, double &) const;
	Moves	whiteMoves(int level, int d1, int d2, double &) const;

public:
	void	setPosition(cchar *pat);
#if	PACKED
	void	setBlack(int ix, char v) { clearBlack(ix); m_black += (uint64)v << shift(ix); }
	void	setWhite(int ix, char v) { clearWhite(ix); m_white += (uint64)v << shift(ix); }
	void	incBlack(int ix) { m_black += one(ix); }
	void	incWhite(int ix) { m_white += one(ix); }
	void	decBlack(int ix) { m_black -= one(ix); }
	void	decWhite(int ix) { m_white -= one(ix); }
	void	clearBlack(int ix) { m_black &= ~mask(ix); }
	void	clearWhite(int ix) { m_white &= ~mask(ix); }
#else
	void	setBlack(int ix, char v) { m_black[ix] = v; }
	void	setWhite(int ix, char v) { m_white[ix] = v; }
	void	incBlack(int ix) { ++m_black[ix]; }
	void	incWhite(int ix) { ++m_white[ix]; }
	void	decBlack(int ix) { --m_black[ix]; }
	void	decWhite(int ix) { --m_white[ix]; }
	void	clearBlack(int ix) { m_black[ix] = 0; }
	void	clearWhite(int ix) { m_white[ix] = 0; }
#endif
	void	swapBW() { qSwap(m_black, m_white); }
	void	moveBlack(int src, int dst);
	void	moveWhite(int src, int dst);
	void	moveBlack(Move mv) { moveBlack(mv.m_src, (int)mv.m_src - mv.m_d); }
	void	moveWhite(Move mv) { moveWhite(mv.m_src, (int)mv.m_src - mv.m_d); }

private:
#if	PACKED
	uint64	m_black;
	uint64	m_white;
#else
	char	*m_black;
	char	*m_white;
	char	m_array[SIZE_S_POINTS_G * 2];
#endif
};

#endif // BOARD_H
