//----------------------------------------------------------------------
//
//			File:			"Board.cpp"
//			Created:		26-Aug-2012
//			Author:			Nobuhide Tsuda
//			Description:	{[hNX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	HalfGammon ̃CZX CDDL 1.0 łB
	http://opensource.org/licenses/cddl-1.0
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	\[XR[h𗬗pꍇApt@C̃CZX CDDL 1.0 ƂȂ܂B
	p̒쌠 HalfGammon ̂̂܂܂łB
	҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	CDDL 1.0 I܂B̃CZXGPLnėp₷AGPLnƂ͖郉CZXȂ̂ŁA
	HalfGammon ̃\[XGPLnvWFNgŎgp邱Ƃ͂ł܂B

*/


#include <QHash>
#include <QSet>
#include "Board.h"

Board::Board()
{
#if PACKED
	m_black = m_white = 0;
#else
	m_white = m_array;
	m_black = m_array + SIZE_S_POINTS_G;
	for(int i = 0; i < sizeof(m_array); ++i)
		m_array[i] = 0;
#endif
}
Board::Board(cchar *pat)
{
#if	PACKED
#else
	m_white = m_array;
	m_black = m_array + SIZE_S_POINTS_G;
#endif
	setPosition(pat);
}
Board::Board(const Board &x)
{
#if	PACKED
	m_black = x.m_black;
	m_white = x.m_white;
#else
	if( x.m_white == x.m_array ) {
		m_white = m_array;
		m_black = m_array + SIZE_S_POINTS_G;
	} else {
		m_white = m_array + SIZE_S_POINTS_G;
		m_black = m_array;
	}
	for(int i = 0; i < sizeof(m_array); ++i)
		m_array[i] = x.m_array[i];
#endif
}
Board &Board::operator=(const Board &x)
{
	if( &x == this ) return *this;
#if	PACKED
	m_black = x.m_black;
	m_white = x.m_white;
#else
	if( x.m_white == x.m_array ) {
		m_white = m_array;
		m_black = m_array + SIZE_S_POINTS_G;
	} else {
		m_white = m_array + SIZE_S_POINTS_G;
		m_black = m_array;
	}
	for(int i = 0; i < sizeof(m_array); ++i)
		m_array[i] = x.m_array[i];
#endif
	return *this;
}
bool Board::operator==(const Board &x) const
{
#if	PACKED
	return m_black == x.m_black && m_white == x.m_white;
#else
	for(int i = 0; i < SIZE_S_POINTS_G; ++i) {
		if( m_black[i] != x.m_black[i] ||
			m_white[i] != x.m_white[i] )
		{
			return false;
		}
	}
	return true;
#endif
}
QByteArray Board::hashKey() const
{
#if PACKED
	QByteArray ba(64/8*2, 0);
	*(uint64*)ba.data() = m_black;
	*((uint64*)ba.data() + 1) = m_white;
#else
	QByteArray ba(SIZE_S_POINTS_G*2, 0);
	for(int i = 0; i < SIZE_S_POINTS_G; ++i) {
		ba[i] = black(i);
		ba[i + SIZE_S_POINTS_G] = white(i);
	}
#endif
	return ba;
}
QString Board::position() const
{
	QString text;
	int n = black(IX_START);
	if( !n )
		text = "G ";
	else
		text = QString("B%1").arg(n);
	for(int i = POINT_START - 1; i > POINT_GOAL; --i) {
		n = position(i);
		if( n > 0 )
			text += QString("B%1").arg(n);
		else if( n < 0 )
			text += QString("W%1").arg(-n);
		else
			text += " .";
	}
	n = white(IX_START);
	if( !n )
		text += " G";
	else
		text += QString("W%1").arg(n);
	return text;
}
//	΁FB or X or >
//	΁FW or O or <
//	           242322212019181716151413121110 9 8 7 6 5 4 3 2 1
//	lF"S B2        W5  W3      B5W5      B3  B5        W2 S"
//	S[ɂΐ͎w肵ȂĂAIɌvẐƂ
//	eʒu10ȏ̐΂ꍇ͐2Lqi͂̕j
void Board::setPosition(cchar *pat)
{
	int nBlack = 0;
	int nWhite = 0;
	for(int i = POINT_START; i >= POINT_GOAL; --i) {
		char t = *pat++;
		char n = *pat++ - '0';
		if( *pat >= '0' && *pat <= '9' )
			n = n * 10 + (*pat++ - '0');
		switch( t ) {
		case 'B':
		case 'X':
		case '>':
			Q_ASSERT( n <= 15 );
			nBlack += n;
			setBlack(i, n);
			setWhite(reverseIX(i), 0);
			break;
		case 'W':
		case 'O':
		case '<':
			Q_ASSERT( n <= 15 );
			nWhite += n;
			setWhite(reverseIX(i), n);
			setBlack(i, 0);
			break;
		default:
			setBlack(i, 0);
			setWhite(reverseIX(i), 0);
		}
	}
	Q_ASSERT( nBlack <= N_PIECE );
	Q_ASSERT( nWhite <= N_PIECE );
	setBlack(IX_GOAL, N_PIECE - nBlack);
	setWhite(IX_GOAL, N_PIECE - nWhite);
}
#if	PACKED
//	Ō̐΂̃CfbNXԂ
//	ʃrbgS[
//	r 12 11 10 X W V U T S R Q P f
int tailIndex(uint64 bb)
{
	if( !(bb & 0xffffff00000000) ) {	//	ʂU|Cgɂ͐΂
		if( !(bb & 0xffff0000) ) {		//	4`7|Cgɐ΂
			if( !(bb & 0xff00) ) {
				if( !(bb & 0xf0) ) return 0;
				return 1;
			} else {
				if( !(bb & 0xf000) ) return 2;
				return 3;
			}
		} else {	//	4`7|Cgɐ΂
			if( !(bb & 0xff000000) ) {
				if( !(bb & 0xf00000) ) return 4;
				return 5;
			} else {	//	8, 9 |Cgɐ΂
				if( !(bb & 0xf0000000) ) return 6;
				return 7;
			}
		}
	} else {	//	r`W|Cgɐ΂
		if( !(bb & 0xff000000000000) ) {
			if( !(bb & 0xff0000000000) ) {
				if( !(bb & 0xf000000000) ) return 8;
				return 9;
			} else {
				if( !(bb & 0xf00000000000) ) return 10;
				return 11;
			}
		} else {	//	ʂS|Cgɐ΂
			if( !(bb & 0xf0000000000000) ) return 12;
			return 13;
		}
	}
}
int Board::blackTailIndex() const
{
	return tailIndex(black());
}
int Board::whiteTailIndex() const
{
	return tailIndex(white());
}
#else
bool Board::canBlackBearOff() const
{
	return m_black[IX_GOAL] +
				m_black[IX_GOAL + 1] + m_black[IX_GOAL + 2] + 
				m_black[IX_GOAL + 3]
			== N_PIECE;
}
bool Board::canWhiteBearOff() const
{
	return m_white[IX_GOAL] +
				m_white[IX_GOAL + 1] + m_white[IX_GOAL + 2] + 
				m_white[IX_GOAL + 3]
			== N_PIECE;
}
//	Ԃ O(N) AN͏ȂAŷŗǂƂĂ
int Board::blackTailIndex() const
{
	for(int ix = IX_START; ix > IX_GOAL; --ix)
		if( black(ix) != 0 ) return ix;
	return IX_GOAL;
}
int Board::whiteTailIndex() const
{
	for(int ix = IX_START; ix > IX_GOAL; --ix)
		if( white(ix) != 0 ) return ix;
	return IX_GOAL;
}
#endif
bool Board::canBlackMoveSrcDst(int src, int dst) const
{
	Board bd(*this);
	bd.swapBW();
	return bd.canWhiteMoveSrcDst(src, dst);
}
bool Board::canWhiteMoveSrcDst(int src, int dst) const
{
	if( !white(src) ) return false;
	if( canWhiteBearOff() ) {
		return dst < IX_GOAL && src == whiteTailIndex()
				|| dst == IX_GOAL
				|| dst > IX_GOAL && black(reverseIX(dst)) <= 1;
	} else
		return dst > IX_GOAL && black(reverseIX(dst)) <= 1;
}
//	w_CX̖ڂŉ\ȒXgAbv
Moves Board::blackMoves(int d1, int d2) const
{
	Board bd(*this);
	bd.swapBW();
	return bd.whiteMoves(d1, d2);
}
//	d1 ܂ d2 gpĈړo钅XgAbv
Moves Board::whiteMoves(int d1, int d2) const
{
	Q_ASSERT( !doesWhiteWin() );
	Moves lst = whiteMoves(d1);
	if( d2 != 0 && d2 != d1 )
		lst << whiteMoves(d2);
	return lst;
}
//	d1 gpĈړo钅XgAbv
Moves Board::blackMoves(int d1) const
{
	Board bd(*this);
	bd.swapBW();
	return bd.whiteMoves(d1);
}
//	d1 gpĈړo钅XgAbv
Moves Board::whiteMoves(int d1) const
{
	Q_ASSERT( !doesWhiteWin() );
	Q_ASSERT( d1 != 0 );
	Moves lst;
	if( nWhiteBar() ) {	//	o[ɐ΂ꍇ
		if( black(d1) <= 1 )
			lst << Move(IX_START, d1);
	} else {
		if( canWhiteBearOff() ) {
			int i = N_DICE;
			while( white(i) == 0 ) --i;		//	΂͕K݂͂
			if( i <= d1 )
				lst << Move(IX_GOAL + i, d1);
			else if( white(d1) != 0 )
				lst << Move(IX_GOAL + d1, d1);
		}
		//	S[ȂXgAbv
		for(int i = IX_START - 1; i > IX_GOAL + 1; --i) {
			if( white(i) != 0 ) {
				int dst = i - d1;
				if( dst > IX_GOAL && black(reverseIX(dst)) <= 1 )
					lst << Move(i, d1);
			}
		}
	}
	return lst;
}
QList<Moves> Board::blackMovesList(int d1, int d2) const
{
	Board bd(*this);
	bd.swapBW();
	return bd.whiteMovesList(d1, d2);
}
QList<Moves> Board::whiteMovesList(int d1, int d2) const
{
	Q_ASSERT( !doesWhiteWin() );
	QSet<QByteArray> set;
	QList<Moves> mvsList;
	Moves lst1 = whiteMoves(d1);
	if( d2 != d1 )
		lst1 << whiteMoves(d2);
	if( lst1.isEmpty() ) return mvsList;
	foreach(Move mv, lst1) {
		Board bd(*this);
		bd.moveWhite(mv);
		Moves curMvs;
		curMvs << mv;		//	ǉ
		if( bd.doesWhiteWin() ) {		//	PŃQ[
			if( !set.contains(bd.hashKey()) ) {
				mvsList << curMvs;
				set << bd.hashKey();
			}
			continue;
		}
		if( d1 != d2 ) {	//	]ڈȊȌꍇ
			int nd = mv.m_d == d1 ? d2 : d1;	//	c̃TCR̖
			Moves lst2 = bd.whiteMoves(nd);
			if( lst2.isEmpty() ) {
				if( !set.contains(bd.hashKey()) ) {
					mvsList << curMvs;
					set << bd.hashKey();
				}
				continue;
			}
			foreach(Move mv2, lst2) {
				Board bd2(bd);
				bd2.moveWhite(mv2);
				if( !set.contains(bd2.hashKey()) ) {
					curMvs << mv2;		//	2ڂǉ
					mvsList << curMvs;
					set << bd2.hashKey();
					curMvs.pop_back();
				}
			}
		} else {	//	]ڂ̏ꍇAڂ4gp
			Moves lst2 = bd.whiteMoves(d1);
			if( lst2.isEmpty() ) {
				if( !set.contains(bd.hashKey()) ) {
					mvsList << curMvs;
					set << bd.hashKey();
				}
				continue;
			}
			foreach(Move mv2, lst2) {
				Board bd2(bd);
				bd2.moveWhite(mv2);
				curMvs << mv2;		//	2ڂǉ
				Moves lst3;
				if( bd2.doesWhiteWin() || (lst3 = bd2.whiteMoves(d1)).isEmpty() ) {
					if( !set.contains(bd2.hashKey()) ) {
						mvsList << curMvs;
						set << bd2.hashKey();
					}
				} else {
					foreach(Move mv3, lst3) {
						Board bd3(bd2);
						bd3.moveWhite(mv3);
						curMvs << mv3;		//	3ڂǉ
						Moves lst4;
						if( bd3.doesWhiteWin() || (lst4 = bd3.whiteMoves(d1)).isEmpty() ) {
							if( !set.contains(bd3.hashKey()) ) {
								mvsList << curMvs;
								set << bd3.hashKey();
							}
						} else {
							foreach(Move mv4, lst4) {
								Board bd4(bd3);
								bd4.moveWhite(mv4);
								if( !set.contains(bd4.hashKey()) ) {
									curMvs << mv4;		//	4ڂǉ
									mvsList << curMvs;
									set << bd4.hashKey();
									curMvs.pop_back();
								}
							}
						}
						curMvs.pop_back();
					}
				}
				curMvs.pop_back();
			}
		}
	}
	return mvsList;
}
QList<Moves> Board::whiteMovesList2(int d1, int d2) const
{
	Q_ASSERT( !doesWhiteWin() );
	QList<Moves> mvsList;
	Moves mvs;
	Move mv;
	Board bd(*this);
	if( d1 != d2 ) {	//	]ڂłȂꍇ
	} else {	//	]ڂ̏ꍇ
		int n = 4;	//	cڂ̐
		if( bd.white(IX_START) != 0 ) {	//	o[ɐ΂ꍇ
			while( n != 0 && bd.white(IX_START) != 0 ) {
				if( bd.black(IX_GOAL + d1) > 1 )	//	ړs
					break;
				mvs << (mv = Move(IX_START, d1));
				bd.moveWhite(mv);
				--n;
			}
			if( bd.white(IX_START) != 0 || !n ) {
				if( !mvs.isEmpty() )
					mvsList << mvs;
				return mvsList;
			}
		}
		//	cn̃_CXڂɂď
		for(int src = IX_START - 1; src > IX_GOAL; --src) {
			if( !white(src) ) continue;
			//	΂ꍇ́AړꍇƈړȂꍇ̗
		}
	}
	return mvsList;
}
void Board::moveBlack(int src, int dst)
{
	swapBW();
	moveWhite(src, dst);
	swapBW();
}
void Board::moveWhite(int src, int dst)
{
	Q_ASSERT( src <= IX_START );
	Q_ASSERT( src > IX_GOAL );
	Q_ASSERT( src > dst );
	Q_ASSERT( white(src) > 0 );
#if 1
	decWhite(src);
	Q_ASSERT( white(src) >= 0 );
	if( dst > IX_GOAL ) {
		if( black(reverseIX(dst)) != 0 ) {
			Q_ASSERT( black(reverseIX(dst)) == 1 );
			clearBlack(reverseIX(dst));
			incBlack(IX_START);
			//m_pipsCount += IX_GOAL - dst;
		}
		incWhite(dst);
		//m_pipsCount -= pipsCount(dst);
	} else {
		incWhite(IX_GOAL);
	}
#else
	--m_white[src];
	Q_ASSERT( white(src) >= 0 );
	//m_pipsCount += pipsCount(src);
	if( dst > IX_GOAL ) {
		if( m_black[reverseIX(dst)] != 0 ) {
			m_black[reverseIX(dst)] = 0;
			++m_black[IX_START];
			//m_pipsCount += IX_GOAL - dst;
		}
		++m_white[dst];
		//m_pipsCount -= pipsCount(dst);
	} else {
		++m_white[IX_GOAL];
	}
#endif
}
//
int eval5Sub(cchar *wa, cchar *ba)
{
	//	SĂ̐΂ɂāA1`3ňړł邩ǂ𒲂ׂ
	int ev = 0;
	int n[] = {0, 0, 0, 0};
	int tailIX = 0;		//	ŌCfbNX
	if( wa[IX_START] ) {	//	o[ɐ΂ꍇ
		for(int d = 1; d <= 3; ++d) {
			switch( ba[IX_GOAL + d] ) {
			case 1:
				ev += (IX_GOAL + d) * 100 / 3;	//	qbg\ȏꍇ
				//	ɃX[
			case 0:
				n[d] += wa[IX_START];
			}
		}
	} else {
		for(int src = IX_START - 1; src > IX_GOAL; --src ) {
			if( wa[src] != 0 ) {
				if( !tailIX ) tailIX = src;
				for(int d = 1; d <= 3; ++d) {
					int dst = src - d;
					if( dst > IX_GOAL ) {
						switch( ba[reverseIX(dst)] ) {
						case 1:
							ev += reverseIX(dst) * 100 / 3;	//	qbg\ȏꍇ
							//	ɃX[
						case 0:
							n[d] += wa[src];
						}
					} else if( tailIX <= IX_GOAL + 3 ) {		//	xAIt\̏ꍇ
						if( dst == IX_GOAL || src == tailIX )
							n[d] += wa[src];
					}
				}
			}
		}
	}
	if( !n[1] ) {
		if( !n[2] ) {
			if( !n[3] )
				ev -= 533;	//	ړoȂꍇ
			else
				ev -= (4+3*2+8)*100/9;	//	1,2 ňړoȂꍇ
		} else {
			if( !n[3] )
				ev -= (4+4*2+12)*100/9;	//	1, 3 ňړoȂꍇ
			else
				ev -= (8)*100/9;	//	2 ňړoȂꍇ
		}
	} else {
		if( !n[2] ) {
            if( !n[3] )
				ev -= (8+5*2+12)*100/9;	//	2, 3 ňړoȂꍇ
            else
				ev -= (4)*100/9;	//	1 ňړoȂꍇ
		} else {
			if( !n[3] )
				ev -= (12)*100/9;	//	3 ňړoȂꍇ
		}
	}
	return ev;
}
//	sbvXCɂ]֐
//	1pips = 100_ƂČvZ
int Board::eval5() const
{
	//	pipsvZ
	//	Ԃ\ߌvZĂAmoveWhite() ŕ␳Ȃ̂ŁA
	//	ȂɏԂrāAȂ炻
	int bp = 0, wp = 0;
#if PACKED
	char ba[14], wa[14];	//	14  0 Ɉړ
	uint64 b = black();
	uint64 w = white();
	for(int i = 0; i < 14; ++i, b>>=4, w>>=4) {
		bp += (ba[i] = b & 0x0f) * i;
		wp += (wa[i] = w & 0x0f) * i;
	}
#else
	for(int i = IX_GOAL + 1; i <= IX_START; ++i) {
		bp += m_black[i] * i;
		wp += m_white[i] * i;
	}
#endif
#if 0
	return (bp - wp) * 100 + 400;		//	400 for Ԃ̗L
#else
#if PACKED
	int s1 = eval5Sub(wa, ba);
	int s2 = eval5Sub(ba, wa);
#else
	int s1 = eval5Sub(m_white, m_black);
	int s2 = eval5Sub(m_black, m_white);
#endif
	return (s1 - s2) + (bp - wp) * 100 + 400;		//	400 for Ԃ̗L
#endif
}
//	sbvX̍ő卷 13*8 = 104 Ȃ̂ŁAieval5  1pips = 100A104pips = 10400j
//	ʏ̏G+3000, MF+6000AobNMF+9000 ƂĂ
#define		NORMAL_WIN			3000
#define		GAMMONED_WIN		6000
#define		BACKGAMMON_WIN		9000

//	P dρ{~j}bNX]
double negaChanceNodeEval5(const Board &bd, int);
double negaMaxEval5(const Board &bd0, int rdepth, int d1, int d2)
{
	Q_ASSERT( !bd0.doesWhiteWin() );
	Q_ASSERT( !bd0.doesBlackWin() );
	double maxEval = -10000;
	QList<Moves> mvsList = bd0.whiteMovesList(d1, d2);
	if( mvsList.isEmpty() ) {
		Board bd(bd0);
		bd.swapBW();
		return - negaChanceNodeEval5(bd, rdepth);
	}
	foreach(Moves mvs, mvsList) {
		Board bd(bd0);
		foreach(Move mv, mvs)
			bd.moveWhite(mv);
		if( bd.doesWhiteWin() ) {
			const int ix = bd.blackTailIndex();
			if( ix >= IX_START - 3 /*bd.doesBlackBackGammonLose()*/ )
				return BACKGAMMON_WIN;
			if( ix > IX_GOAL + 3 /*bd.doesBlackGammonLose()*/ )
				return GAMMONED_WIN;
			return NORMAL_WIN;
		}
		bd.swapBW();
		double ev = - negaChanceNodeEval5(bd, rdepth);
		maxEval = qMax(maxEval, ev);
	}
	return maxEval;
}
double negaChanceNodeEval5(const Board &bd, int rdepth)
{
	if( !--rdepth ) {
		return bd.eval5();
	}
	double t = 0;
	t += negaMaxEval5(bd, rdepth, 1, 1);
	t += negaMaxEval5(bd, rdepth, 2, 2);
	t += negaMaxEval5(bd, rdepth, 3, 3);
	t += negaMaxEval5(bd, rdepth, 1, 2) * 2;
	t += negaMaxEval5(bd, rdepth, 1, 3) * 2;
	t += negaMaxEval5(bd, rdepth, 2, 3) * 2;
	return t / 9;
}
Moves Board::whiteMovesEval5PlyD(int depth, int d1, int d2, double &eval) const
{
	Q_ASSERT( !doesWhiteWin() );
	Q_ASSERT( !doesBlackWin() );
	QList<Moves> mvsList = whiteMovesList(d1, d2);
	Moves bestMvs;
	if( mvsList.isEmpty() ) return bestMvs;
	if( mvsList.size() == 1 ) return mvsList[0];
	double ev, maxEval = -10000;
	foreach( Moves mvs, mvsList ) {
		Board bd(*this);
		foreach(Move mv, mvs) {
			bd.moveWhite(mv);
		}
		if( bd.doesWhiteWin() ) {
			bestMvs = mvs;
			const int ix = bd.blackTailIndex();
			if( ix >= IX_START - 3 /*bd.doesBlackBackGammonLose()*/ )
				maxEval = BACKGAMMON_WIN;
			else if( ix > IX_GOAL + 3 /*bd.doesBlackGammonLose()*/ )
				maxEval = GAMMONED_WIN;
			else
				maxEval = NORMAL_WIN;
			break;
		} else {
			bd.swapBW();
			ev = -negaChanceNodeEval5(bd, depth);
		}
		if( ev > maxEval ) {
			maxEval = ev;
			bestMvs = mvs;
		}
	}
	//qDebug() << "maxEval " << maxEval;
	eval = maxEval;
	return bestMvs;
}
//	_ɒI
Moves Board::whiteMovesRandom(int d1, int d2) const
{
	QList<Moves> mvsList = whiteMovesList(d1, d2);
	Moves bestMvs;
	if( mvsList.isEmpty() ) return bestMvs;
	if( mvsList.size() == 1 ) return mvsList[0];
	return mvsList[qrand() % mvsList.size()];
}
Moves Board::whiteMoves(int level, int d1, int d2, double &eval) const
{
	eval = 0;
	Moves mvs;
	switch( level ) {
	case LEVEL_RANDOM:
		mvs = whiteMovesRandom(d1, d2);
		break;
	case LEVEL_BEGINNER:
		mvs = !(qrand() & 1) ? whiteMovesEval5PlyD(1, d1, d2, eval)
				: whiteMovesRandom(d1, d2);
		break;
	case LEVEL_INTERMEDIATE:
		mvs = whiteMovesEval5PlyD(1, d1, d2, eval);
		break;
	case LEVEL_ADVANCED:
		mvs = whiteMovesEval5PlyD(3, d1, d2, eval);
		break;
	}
	return mvs;
}
Moves Board::blackMoves(int level, int d1, int d2, double &eval) const
{
	Board bd(*this);
	bd.swapBW();
	return bd.whiteMoves(level, d1, d2, eval);
}
