#ifndef MAINWINDOW_H
#define MAINWINDOW_H

//----------------------------------------------------------------------
//
//			File:			"MainWindow.h"
//			Created:		26-Aug-2012
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	HalfGammon ̃CZX CDDL 1.0 łB
	http://opensource.org/licenses/cddl-1.0
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	\[XR[h𗬗pꍇApt@C̃CZX CDDL 1.0 ƂȂ܂B
	p̒쌠 HalfGammon ̂̂܂܂łB
	҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	CDDL 1.0 I܂B̃CZXGPLnėp₷AGPLnƂ͖郉CZXȂ̂ŁA
	HalfGammon ̃\[XGPLnvWFNgŎgp邱Ƃ͂ł܂B

*/

#include <QtGui>
#include "ui_mainwindow.h"

//#include "Board.h"

class QTimer;
class QPlainTextEdit;
class QGraphicsScene;
class QGraphicsView;
class QGraphicsRectItem;
class QGraphicsSimpleTextItem;
class QGraphicsEllipseItem;
class Board;
class TreeSearch;
class QNetworkAccessManager;
class QNetworkReply;
struct Move;

/*

                        
                              
                        
                                                  
      
      r                        r
      f                        f
      
 point: 13  12  11  10  X  W  V  U  T  S  R  Q  P  O


*/

struct Statistics
{
	int		m_rating;
	int		m_winCount;
	int		m_gameCount;
public:
	Statistics()
		: m_rating(1500)
		, m_winCount(0)
		, m_gameCount(0)
		{}
};

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	enum {
		GS_INIT = 0,		//	
		GS_NEW_GAME,		//	Q[Jn
		GS_INIT_ROLLING_DICE,	//	_CXlX 
		GS_ROLLING_DICE,	//	_CXlXV
		GS_HUMAN_ROLL,		//	_CXUiNbNĵ҂
		GS_INIT_HUMAN_SRC,	//	ړ΂̑I҂ 
		GS_HUMAN_SRC,		//	ړ΂̑I҂
		GS_HUMAN_DST,		//	ړI҂
		GS_WAIT_FOR_DECIDED,	//	^[I or undo ҂
		GS_INIT_MOVING_PIECE,
		GS_MOVING_PIECE,
		GS_MOVING_PIECE_FINISHED,
		GS_INIT_COMP_TURN,		//	Rs[^ԏ
		GS_COMP_TURN,
		GS_COMP_SEARCHING,

		N_LEVEL = 4,

		N_DICE = 3,
		N_CELL = N_DICE * 4,			//	tB[h̐

		IX_START = N_CELL + 1,
		IX_GOAL = 0,
		POINT_BLACK_START = N_CELL + 1,		//	[
		POINT_BLACK_GOAL = 0,				//	E[
		POINT_WHITE_START = 0,				//	E[
		POINT_WHITE_GOAL = N_CELL + 1,		//	[

		CELL_WD = 56,
		CELL_HT = CELL_WD * 4,
		DICE_WD = CELL_WD - 8,
		DICE_MARGIN = (CELL_WD - DICE_WD) /2,
		DICE_X = CELL_WD * 3 + DICE_MARGIN,
		DICE_Y = 0,
		DICE_NUM_Y = DICE_Y - 2,
		NAME_X = CELL_WD * 6,
		NAME_WD = CELL_WD * 2,
		PIP_X = CELL_WD * 9,
		PIP_Y = DICE_Y,
		PIP_Y2 = PIP_Y + CELL_WD / 2,
		ORG_X = 0,					//	Ֆʌ_ʒu
		ORG_Y = CELL_WD,
		PIECE_Y = ORG_Y + CELL_WD * 3,		//	1ڂ̐΂̈ʒu
		PIECE_MARGIN = CELL_WD / 10,
		PIECE_WD = CELL_WD - PIECE_MARGIN * 2,
	};

public:
	MainWindow(QWidget *parent = 0, Qt::WFlags flags = 0);
	~MainWindow();

protected:
	int		pointToPx(int p) const { return (POINT_BLACK_START - p) * CELL_WD; }
	int		ixToPx(int ix) const { return ix * CELL_WD; }
	int		xyToPoint(int, int) const;
	void	pointToXY(int, int &, int &) const;
	int		xyToIndex(int, int) const;
	void	indexToXY(int, int &, int &) const;
	bool	isBlackTurn() const { return m_blackTurn > 0; }
	bool	canMove(int src, int dst) const;
	bool	isForcedMoveDest() const;

protected:
	void	createDockWindows();
	void	doOutput(const QString &);		//	AEgvbgyCɃeLXgo
    void	readSettings();
    void	writeSettings();
    QGraphicsEllipseItem	*addCircle(qreal, qreal, qreal,
    									const QPen &, const QBrush &,
    									QGraphicsItem * = 0);
	void	addEyebrow(qreal, qreal, qreal, QGraphicsItem *);
	void	setupBoardItems();		//	ΈȊÕACezu
	void	placePieces();			//	m_board QƂA΂zu
	QGraphicsItem	*addPiece(int, int, bool, int=20, QString = QString());
	QGraphicsItem	*findPiece(int px, int py);
	QGraphicsItem	*findPiece(int ix);
	void	clearPieces();
	void	setupSrcMarks();
	void	setSrcMarks(int, bool = true);
	bool	setDstMarks(int);
	void	clearSrcMarks();
	void	clearDstMarks();
	void	removeDice(int);
	void	addDice(int);
	void	updateDice();
	void	updateDiceItems();
	bool	isPossibleToMove();		//	ړ\ǂ`FbN
	void	updateNextItem();
	void	newGame();
	void	onStateChanged();
	void	whiteTurn();
	void	updateRating(int &, int &);
	bool	confirmToTerminate();
	void	doExit();
	void	sound(const QString &);

protected slots:
	void	onTimer();
	void	onSearchFinished(double);
    void	replyFinished(QNetworkReply* reply);

protected:
	void	mousePressEvent ( QMouseEvent * event );
	void	keyPressEvent ( QKeyEvent * e );
	void	closeEvent(QCloseEvent *event);

private slots:
    void on_action_Exit_triggered();
    void on_action_NewGame_triggered();
    void on_action_Undo_triggered();
    void on_action_Settings_triggered();
    void on_action_Statistics_triggered();
    void on_action_ClearStatistics_triggered();
    void on_action_Help_triggered();
    void on_action_AboutHalfGammon_triggered();

private:
	Ui::MainWindowClass ui;
	bool	m_firstMoveBlack;
	bool	m_undoAvailable;
	int		m_gameMode;
	uchar	m_compType;
	uchar	m_comp2Type;
	uchar	m_gameState;
	uchar	m_nextGameState;	//	ΈړǏ̎̏
	Statistics	m_humanStat;
	Statistics	m_compStat[N_LEVEL];
#if 0
	int		m_winCount;
	int		m_gameCount;
	int		m_humanRating;		//	lԂ̃[eBO
	int		m_compRating[3];	//	Rs[^[eBO
#endif
	int		m_blackTurn;		//	1 for BLACK, -1 for WHITE
	int		m_turn;
	int		m_dice[4];			//	TCȐo
	int		m_srcPoint;			//	ړ΂̂}Xڃ|Cg
	int		m_dstPoint;			//	ړCfbNX
	int		m_d;				//	ړɎgp_CX̖
	int		m_srcPx;
	int		m_srcPy;
	int		m_dstPx;
	int		m_dstPy;
	int		m_animationSpeed;		//	[1, 5]
	int		m_movingProgress;		//	[0, 100]
	bool	m_movingHumanPiece;
	//bool	m_hit;						//	qbgꂽ΂
	bool	m_autoMoveDst;				//	Iꂽ΂̈ړ悪ӏ̏ꍇ́Aړ
	QList<Move>	m_compMove;				//	IꂽRs[^̒
	QList<Board>	m_boardHist;		//	for undo
	QList<int>		m_diceHist;			//	for undo
	QThread		*m_thread;				//	obNOEhTpXbh
	TreeSearch	*m_treeSearch;			//	ؒTIuWFNg
	QString		m_blackColorText;
	QString		m_whiteColorText;
	QColor		m_blackColor;
	QColor		m_whiteColor;
	Board		*m_board;
	QTimer		*m_timer;
	QTime		m_rollDiceTime;			//	TCR[OJn^C
	QPlainTextEdit	*m_output;			//	o̓yCEBWbg
    QNetworkAccessManager	*m_networkAccessManager;
	QGraphicsScene	*m_scene;
	QGraphicsView	*m_view;
	QGraphicsItem	*m_nextItem;
	QGraphicsItem	*m_movingItem;		//	ړ΃ACe
	QGraphicsItem	*m_hitItem;			//	qbgꂽ΃ACe
	QGraphicsEllipseItem	*m_blackPipsItem;
	QGraphicsEllipseItem	*m_whitePipsItem;
	QList<QGraphicsSimpleTextItem *>	m_diceItems;
	QList<int>		m_dstList;					//	ړ惊Xg
	QList<int>		m_dList;					//	_CXڃXg
	QList<QGraphicsRectItem *>	m_srcMarks;		//	ړ}[N
	QList<QGraphicsRectItem *>	m_dstMarks;		//	ړ}[N
	QList<QGraphicsItem *>		m_pieces;		//	΃ACeւ̃|C^
	QGraphicsSimpleTextItem		*m_blackNameTextItem;
	QGraphicsSimpleTextItem		*m_whiteNameTextItem;
	QGraphicsSimpleTextItem		*m_blackPipsTextItem;
	QGraphicsSimpleTextItem		*m_whitePipsTextItem;
};

#endif // MAINWINDOW_H
