#include <QTest>
#include <QDebug>
#include <time.h>
#include "TestBoard.h"
#include "../NikoNikoGammon/Board.h"
#include <vector>
#include <boost/timer.hpp>

TestBoard::TestBoard(QObject *parent)
	: QObject(parent)
{

}

TestBoard::~TestBoard()
{

}
void TestBoard::testBoard()
{
	Board bd;
	qDebug() << bd.position();
	bd.setPosition("G B2. W2B1W1B2. W2 G");
	qDebug() << bd.position();
	QCOMPARE( bd.blackPips(), 27 );
	{
		Board bd2("G B2. W2B1W1B2. W1 G");
		bd2.swapBW();
		qDebug() << bd2.position();
		bd2.swapBW();
		qDebug() << bd2.position();
	}
	{
		Board bd2("G B2. W2B1W1B2. W2 G");
		Moves mvs = bd.whiteMoves(1);
		QCOMPARE( mvs.size(), 3 );
		mvs = bd.whiteMoves(2);
		QCOMPARE( mvs.size(), 1 );
		QList<Moves> mvsList = bd.whiteMovesList3(1, 1);
		QCOMPARE( mvsList.size(), 6 );
	}
	{
		bd.setPosition(INIT_BOARD);
		QList<Moves> mvsList = bd.whiteMovesList3(1, 0);
		QCOMPARE( mvsList.size(), 3 );
	}
}
void TestBoard::benchRandomGame3()
{
	qsrand((int)time(0));
#ifdef _DEBUG
	const int N_LOOP = 100;
#else
	const int N_LOOP = 1000;
#endif
	int gameCount = 0;
	int turnCount = 0;
	int mvsCount = 0;
	QBENCHMARK_ONCE {
		for(int i = 0; i < N_LOOP; ++i) {
			++gameCount;
			Board bd(INIT_BOARD);		//	
			bool blackTurn = true;
			for(bool init = true;;) {
				//qDebug() << bd.position();
				if( blackTurn )
					bd.swapBW();
				int d1, d2;
				do {
					d1 = (qrand() % 3);
					d2 = (qrand() % 3);
				} while( init && d1 == d2 );
				init = false;
				//QString mvStr;
				if( d1 != 0 || d2 != 0 ) {
					QString text = bd.position();
					//Board bd2(bd);
					QList<Moves> mvsList = bd.whiteMovesList3(d1, d2);
					//if( bd.nBlack() != N_PIECE || bd.nWhite() != N_PIECE )
					//	mvsList = bd2.whiteMovesList3(d1, d2);
					Q_ASSERT( bd.nBlack() == N_PIECE );
					Q_ASSERT( bd.nWhite() == N_PIECE );
					QString pos = bd.position();
					if( !mvsList.isEmpty() ) {
						mvsCount += mvsList.size();
						++turnCount;
						QList<Move> mvs = mvsList[qrand() % mvsList.size()];
						foreach(Move mv, mvs) {
							//mvStr += mv.toString();
							bd.moveWhite(mv);
						}
					}
				}
				if( blackTurn )
					bd.swapBW();
				//qDebug() << d1 << d2 << bd.position() << mvStr;
				Q_ASSERT( bd.nBlack() == N_PIECE );
				Q_ASSERT( bd.nWhite() == N_PIECE );
				if( bd.doesBlackWin() || bd.doesWhiteWin() ) break;
				blackTurn = !blackTurn;
			}
		}
	}
	qDebug() << "gameCount = " << gameCount;
	qDebug() << "ave turn count = " << (double)turnCount / gameCount;
	qDebug() << "ave mvs count = " << (double)mvsCount / turnCount;
}
void TestBoard::testPN()
{
	QVector<int> v;
	init_PN(v, 3, 2);
	qDebug() << v;
	while( next_PN(v, v.size()) )
		qDebug() << v;
	{
		uchar v[4] = {2, 0, 0, 0};
		while( next_PN(v, sizeof(v)) )
			qDebug() << v[0] << v[1] << v[2] << v[3];
	}

	QCOMPARE( PNC(1, 0), 1 );
	QCOMPARE( PNC(3, 2), 6 );
	QCOMPARE( PNC(4, 8), 165 );
}
//	{n, 0,...0}  #0 ƂĐ
template<typename Container>
int seqNumber(const Container v,
				int ix,		//	v[ix`0] Q
				int n)		//	index <= ix ̐ΐ
{
	Q_ASSERT( ix >= 0 );
	if( !n ) return 0;		//	0̐΂̒u͂Ђƒʂ肵Ȃ
	if( !ix ) return 0;		//	Ō͎̌IɌ܂

	int sum = 0;	//	ix ̌ [0, v[ix]) ̏ꍇ̐𐔂
	for(int i = 0; i < v[ix]; ++i) {
		sum += PNC(ix, n - i);
	}
	return seqNumber(v, ix - 1, n - v[ix]) + sum;
}
//	΂݂̂ꍇ
void TestBoard::testSeqNumber0()
{
	uchar v[4] = {2, 0, 0, 0};
	QCOMPARE( seqNumber(v, sizeof(v)-1, 2), 0 );
	int sn = 0;
	while( next_PN(v, sizeof(v)) ) {
		QCOMPARE( seqNumber(v, sizeof(v)-1, 2), ++sn );
	}
}
void TestBoard::testSeqNumber()
{
	Board bd;
	bd.setPosition("G W1. . . . . . B1 G");
	QCOMPARE( bd.seqNumber(), 0 );
	bd.setPosition("G W2. . . . . . B1 G");
	QCOMPARE( bd.seqNumber(), 1 );
	bd.setPosition("G W5. . . . . . B1 G");
	QCOMPARE( PNC(2, 5) - 2, 4 );
	QCOMPARE( bd.seqNumber(), 4 );
	bd.setPosition("G . W1. . . . . B1 G");
	QCOMPARE( PNC(2, 5) - 1, 5 );		//	PNC(2, 5)  {5, 0} ܂ł邽 - 1
	QCOMPARE( bd.seqNumber(), 5 );
	bd.setPosition("G . . . . . . . B1W5");		//	B1 G ł́A̍Ō̏
	QCOMPARE( PNC(9, 5), 1287 );
	QCOMPARE( bd.seqNumber(), 1285 );
	bd.setPosition("G W1. . . . . . B2 G");
	QCOMPARE( bd.seqNumber(), 1286 );
	bd.setPosition("G W1. . . . . . B3 G");
	QCOMPARE( bd.seqNumber(), 1286*2 );
	bd.setPosition("G W1. . . . . . B5 G");
	QCOMPARE( bd.seqNumber(), 1286*4 );
	bd.setPosition("G W5. . . . . . B5 G");
	QCOMPARE( bd.seqNumber(), 1286*4 + 4 );
	bd.setPosition("G W1. . . . . B1.  G");
	QCOMPARE( bd.seqNumber(), 1286*5 );

	bd.setPosition("B5. . . . . . . . W5");
	QCOMPARE( bd.seqNumber(), 1106945 - 1 );
}
//	p ӏ n ̐΂up^[
template<typename Container>
bool init_NC(Container &v, int p, int n)
{
	if( n < 0 || p <= 0 ) return false;
	v.clear();
	v << n;
	for(int i = 1; i < p; ++i)
		v << 0;
	return true;
}
template<typename Container>
bool next_NC(Container &v)
{
	if( v.size() == 1 ) return false;
	//	{n0 n1, ...}  {n0-1, n1+1, ...}
	//	{0, n1, n2,...}  {n1-1, 0, n2+1, ...}
	//	{0, ... 0, ni, nj,...}  {ni-1, 0, ... 0, nj +1, ...}
	//	{0, ...n}  return false;
	if( v[0] > 0 ) {
		--v[0];
		++v[1];
	} else {
		int i = 1;
		for(;;) {
			if( i == v.size() - 1 ) return false;
			if( v[i] != 0 ) break;
			++i;
		}
		++v[i+1];
		v[0] = v[i] - 1;
		v[i] = 0;
	}
	return true;
}
template<int NP, int NS>
qint64 countPosition()
{
	QVector<int> b, w;
	qint64 sum = 0;
	init_NC(b, NP + 2, NS);
	while( next_NC(b) ) {
		int s = 0;	//	󔒃|Cg
		for(int i = 1; i <= NP; ++i)
			if( !b[i] ) ++s;
		sum += PNC(s + 2, NS) - 1;
#if 0
		init_NC(w, s + 2, NS);
		while( next_NC(w) )
			++sum;
#endif
	}
	return sum;
}
void TestBoard::benchCountPosition()
{
	qint64 c = 0;
	QBENCHMARK_ONCE {
		c = countPosition<8, 5>();
	}
	qDebug() << c;
}
void TestBoard::benchQVector()
{
	QBENCHMARK {
		QVector<int> v;
		for (int i = 0; i < 100000; i++)
			v << i;
	}
}
void TestBoard::benchSTDVector()
{
	QBENCHMARK {
		std::vector<int> v;
		for (int i = 0; i < 100000; i++)
			v.push_back(i);
	}
}
void TestBoard::benchArray()
{
	const int ARRAY_SIZE = 1000*1000;
	QBENCHMARK {
		int *v = new int[ARRAY_SIZE];
		for (int i = 0; i < ARRAY_SIZE; i++)
			v[i] = i;
		delete [] v;
	}
}
void TestBoard::benchArraySum()
{
	const int ARRAY_SIZE = 1000*1000;
	boost::timer tm;
	int *v = new int[ARRAY_SIZE];
	for (int i = 0; i < ARRAY_SIZE; i++)
		v[i] = i;
	double dur1 = tm.elapsed();
	int sum = 0;
	for (int i = 0; i < ARRAY_SIZE; i++)
		sum += v[i];
	double dur2 = tm.elapsed();
	qDebug() << dur1 << dur2 - dur1 << sum;
	delete [] v;
}
template<typename Container>
bool isOverlap(const Container &b, const Container &w, int sz)
{
	for(int ix = 1; ix < sz - 1; ++ix) {
		if( b[ix] != 0 && w[sz - ix - 1] != 0 )
			return true;
	}
	return false;
}
//	Ԃɐ
template<typename Container>
bool next_position(Container &b, Container &w, int sz, int nStone)
{
	if( b[0] == nStone )
		next_PN(b, sz);
	for(;;) {
		if( next_PN(w, sz) ) {
			if( isOverlap(b, w, sz) )	//	ix = [1, sz - 1) ͈͂́Aꏊɗ̐΂
				continue;
			return true;
		}
		if( !next_PN(b, sz) )
			return false;
		w[0] = nStone;
		for(int ix = 1; ix < sz; ++ix)
			w[ix] = 0;
	}
}
void TestBoard::testGenSeq()
{
	const int nStone = 2;
	uchar b[4] = {nStone, 0, 0, 0};
	uchar w[4] = {nStone, 0, 0, 0};
	int sn = 0;
	while( next_position(b, w, sizeof(b), nStone) ) {
		qDebug() << QString("#%1:").arg(++sn, 2)
					<< b[0] << b[1] << b[2] << b[3] << ", "
					<< w[0] << w[1] << w[2] << w[3];
	}
	qDebug() << "countPosition<2, 2>() =" << countPosition<2, 2>();
}
#if		0
template<typename Container>
bool prev_PN(Container &v, int vSize)
{
	//	{n1, n2, ...}  {n1+1, n2-1, ...}
	//	{n1, 0, n2,...}  {0, n1+1, n2-1, ...}
	//	{n1, 0, ... 0, n2,,...}  {0, ...0, n1+1, nj -1, ...}
	//	{n, 0, ...0}  return false;
	if( v[1] > 0 ) {
		++v[0];
		--v[1];
	} else {
		int i = 2;
		for(;;) {	//	v[1] ȍ~ v[i] != 0 T
			if( i >= vSize ) return false;
			if( v[i] != 0 ) break;
			++i;
		}
		--v[i];
		v[i-1] = v[0] + 1;
		v[0] = 0;
	}
	return true;
}
#endif
static QVector<int> g_sum(2002, -1);
template<typename Container>
int seqNumber(const Container &b, const Container &w, int sz, int nStone)
{
	//	̂ЂƂO܂ł̏Ԑ{̃V[PVԍ
	//		 Aseqԍ͍ӏ
	QVector<Container::value_type> v(b);
	const int sn = seqNumber(b, sz - 1, nStone);
	int sum = g_sum[sn];
	if( sum < 0 ) {
		sum = 0;
		while( prev_PN(v, v.size()) && v[0] != nStone ) {
			int ns = 0;		//	1`sz-1 |Cg̋󔒐
			for(int ix = 1; ix < sz - 1; ++ix)
				if( v[ix] == 0 ) ++ns;
			sum += PNC(ns + 2, nStone) - 1;
		}
		g_sum[sn] = sum;
		//qDebug() << "g_sum[" << sn << "] = " << sum;
	}
	v.clear();
	v << w[0];
	for(int i = 1; i < sz - 1; ++i) {
		if( b[sz - i - 1] == 0 )
			v << w[i];
	}
	v << w[sz - 1];
	return sum + seqNumber(v, v.size()-1, nStone) - 1;
}

void TestBoard::testSeqNumber2()
{
	{
		uchar v[4] = {0, 0, 0, 2};
		while( prev_PN(v, sizeof(v)) )
			qDebug() << v[0] << v[1] << v[2] << v[3];
	}
	const int nStone = 2;
	QVector<int> b;
	QVector<int> w;
	init_PN(b, 4, nStone);
	init_PN(w, 4, nStone);
	int sn = -1;
	while( next_position(b, w, b.size(), nStone) ) {
		QCOMPARE( seqNumber(b, w, b.size(), nStone), ++sn );
	}
}
void TestBoard::benchGenSeq()
{
	const int nStone = 5;
	QVector<int> b;
	QVector<int> w;
	init_PN(b, 10, nStone);
	init_PN(w, 10, nStone);
	int sn = 0;
	QBENCHMARK_ONCE {
		while( next_position(b, w, b.size(), nStone) ) {
			++sn;
		}
	}
	qDebug() << "sn = " << sn;
}
void TestBoard::benchGenHashTable()
{
	QHash<QByteArray, short> hashTable;
	const int nStone = 5;
	QVector<char> b;
	QVector<char> w;
	init_PN(b, 10, nStone);
	init_PN(w, 10, nStone);
	int sn = 0;
	QBENCHMARK_ONCE {
		while( next_position(b, w, b.size(), nStone) ) {
			QByteArray ba(b.data(), b.size());
			ba.append(w.data(), w.size());
			hashTable[ba] = sn;
			++sn;
		}
	}
	qDebug() << "sn = " << sn;
}
void TestBoard::benchSeqNumber()
{
	const int nStone = 5;
	QVector<int> b;
	QVector<int> w;
	init_PN(b, 10, nStone);
	init_PN(w, 10, nStone);
	int sn = -1;
	QBENCHMARK_ONCE {
		while( next_position(b, w, b.size(), nStone) ) {
			++sn;
			//if( sn == 1286 )
			//	qDebug() << sn;
			QCOMPARE( seqNumber(b, w, b.size(), nStone), sn );
		}
	}
	qDebug() << "sn = " << sn;
}
void TestBoard::benchBlackSeqNumber()
{
	const int nStone = 5;
	int sn = 0;
	QBENCHMARK_ONCE {
		QVector<char> b;
		init_PN(b, 10, nStone);
		while( next_PN(b, b.size()) ) {
			QCOMPARE( seqNumber(b, 9, nStone), ++sn );
		}
	}
	qDebug() << "sn = " << sn;
}
//----------------------------------------------------------------------
#define		UNKNOWN_EXPVAL			(short)0x8000
#define		BACKGAMMON_WIN_EXPVAL	(short)30000
#define		GAMMONED_WIN_EXPVAL		(short)20000
#define		NORMAL_WIN_EXPVAL		(short)10000
QVector<short> g_expectVal(1106945, UNKNOWN_EXPVAL);

//	Ƃ肠pX͖̂ƂijOԂȂ炨j
short blackExpVal(const Board &bd);
short negaMaxBlackExp(const Board &bd0, int d1, int d2)
{
	short maxExpVal = -30000;
	QList<Moves> mvsList = bd0.blackMovesList3(d1, d2);
	if( mvsList.isEmpty() ) {
		Q_ASSERT( 0 );
		return 0;
	}
	foreach(Moves mvs, mvsList) {
		Board bd(bd0);
		foreach(Move mv, mvs)
			bd.moveBlack(mv);
		if( bd.doesBlackWin() ) {
			const int ix = bd.blackTailIndex();
			if( ix >= IX_START - N_DICE /*bd.doesBlackBackGammonLose()*/ )
				return BACKGAMMON_WIN_EXPVAL;
			if( bd.doesBlackGammonLose() )
				return GAMMONED_WIN_EXPVAL;
			return NORMAL_WIN_EXPVAL;
		}
		bd.swapBW();
		short ev = - blackExpVal(bd);
		//const int sn = bd.seqNumber();
		//short ev = -g_expectVal[sn];
		Q_ASSERT( ev != UNKNOWN_EXPVAL );
		maxExpVal = qMax(maxExpVal, ev);
	}
	return maxExpVal;
}
//	Ԃł̊ҒlԂ
short blackExpVal(const Board &bd)
{
	const int sn = bd.seqNumber();
	short ev = g_expectVal[sn];
	if( ev != UNKNOWN_EXPVAL ) return ev;
	int t = 0;
	t += negaMaxBlackExp(bd, 1, 1);
	t += negaMaxBlackExp(bd, 2, 2);
	t += negaMaxBlackExp(bd, 0, 1) * 2;
	t += negaMaxBlackExp(bd, 0, 2) * 2;
	t += negaMaxBlackExp(bd, 1, 2) * 2;
	return g_expectVal[sn] = (short)(t / 8);
}
//	SԂ̊ҒlvZ
void TestBoard::buildExpectTable()
{
	Board bd;
	bd.setPosition("G W1. . . . . . B1 G");
	QCOMPARE( blackExpVal(bd), NORMAL_WIN_EXPVAL );
	bd.setPosition("G W1. . . . . . B2 G");		//	11 12 22 ŏ p = 4/8, ev = 2*p - 1 = 0
	QCOMPARE( blackExpVal(bd), (short)0 );
	bd.setPosition("G W2. . . . . . B2 G");		//	11 12 22 ŏ, łȂĂ 1/2 ŏ p = 3/4, ev = 2*p - 1 = 0.5
	QCOMPARE( blackExpVal(bd), (short)5000 );
	bd.setPosition("G W5. . . . . . B5 G");
	qDebug() << bd.position() << blackExpVal(bd)/10000.0;
	bd.setPosition("G . W5. . . . B5.  G");
	qDebug() << bd.position() << blackExpVal(bd)/10000.0;
	bd.setPosition("G . . W5. . B5. .  G");
	qDebug() << bd.position() << blackExpVal(bd)/10000.0;
	bd.setPosition("G . . . W5B5. . .  G");
	qDebug() << bd.position() << blackExpVal(bd)/10000.0;
}
