#include "TestMiniBoard.h"
#include "../MiniGammon/Board.h"
#include <QTest>
#include <QDebug>
#include <time.h>

TestMiniBoard::TestMiniBoard(QObject *parent)
	: QObject(parent)
{

}

TestMiniBoard::~TestMiniBoard()
{

}
void TestMiniBoard::testBoard()
{
	Board bd("G B2. . W3. W2. B3W3. B2. B3. . W2 G");	//	
	qDebug() << bd.position();
	QCOMPARE( bd.position(), QString("G B2. . W3. W2. B3W3. B2. B3. . W2 G") );
}
//	\擾eXg
void TestMiniBoard::testGetMoves()
{
	Board bd("G B2. . W3. W2. B3W3. B2. B3. . W2 G");	//	
	QList<Moves> mvsList = bd.whiteMovesList(4, 4);	//	3-3 ɂ\胊Xg擾
	QCOMPARE( mvsList.size(), 8 );

	bd.setPosition("G W4W2. . . . . . W1. . . B1B1W3B6 G");
	mvsList = bd.whiteMovesList(3, 3);
	QCOMPARE( mvsList.size(), 7 );

	bd.setPosition("G . W6. B1B1. B2. . . . B2B2W3B2. W1");
	mvsList = bd.whiteMovesList3(3, 2);
	QCOMPARE( mvsList.size(), 1 );
	Moves mvs = mvsList[0];
	QCOMPARE( mvs.size(), 1 );
	Move mv = mvs[0];

	bd.setPosition("G B2W2W2W4. . . . . . . . . . . .  G");
	mvsList = bd.whiteMovesList3(3, 3);
	QCOMPARE( mvsList.size(), 1 );
	mvs = mvsList[0];
	QCOMPARE( mvs.size(), 2 );
	mv = mvs[0];

	bd.setPosition("G W4W2. W2. . . . . B1B2B2B2B2W2B1 G");
	mvsList = bd.whiteMovesList3(4, 2);
	QCOMPARE( mvsList.size(), 1 );
}
void TestMiniBoard::testEval5Ply1()
{
	double eval;
	Board bd("G B2W2W6. B1. W1B1. B1. . . . B5. W1");
	QList<Moves> mvsList = bd.whiteMovesList3(3, 3);	//	3-3 ɂ\胊Xg擾
	QCOMPARE( mvsList.size(), 2 );
	QList<Move> mvs = mvsList[0];
	QCOMPARE( mvs.size(), 4 );
	mvs = bd.whiteMovesEval5PlyD(1, 3, 3, eval);	//	1ǂ݁{eval5()
	QVERIFY( !mvs.isEmpty() );
	QCOMPARE( mvs.size(), 4 );
}
void TestMiniBoard::testEval5Ply3()
{
	double eval;
	Board bd("G W3W1W1. . B1. . . . B3B2B2W1B2W3W1");
	QList<Moves> mvsList = bd.whiteMovesList3(3, 1);	//	3-1 ɂ\胊Xg擾
	QCOMPARE( mvsList.size(), 2 );
	QList<Move> mvs = bd.whiteMovesEval5PlyD(3, 3, 1, eval);	//	3ǂ݁{eval5()
	QVERIFY( !mvs.isEmpty() );

	bd.setPosition("G . W6. B1B1. B2. . . . B2B2W3B2. W1");
	mvs = bd.whiteMovesEval5PlyD(3, 3, 2, eval);	//	3ǂ݁{eval5()
	QVERIFY( !mvs.isEmpty() );

	bd.setPosition("G W5. . . . . . . . . . . B1B1B2B2 G");
	mvsList = bd.whiteMovesList3(4, 4);
	QCOMPARE( mvsList.size(), 1 );
	mvs = bd.whiteMovesEval5PlyD(3, 4, 4, eval);	//	3ǂ݁{eval5()
	QVERIFY( !mvs.isEmpty() );

	//	SPR#0004
	bd.setPosition("G W2W4. . . . W2. . . . . . W1B1B2W1");
	mvsList = bd.whiteMovesList3(4, 4);
	QCOMPARE( mvsList.size(), 9 );
	mvs = bd.whiteMovesEval5PlyD(3, 4, 4, eval);	//	3ǂ݁{eval5()
	QVERIFY( !mvs.isEmpty() );
	foreach(Move mv, mvs)
		bd.moveWhite(mv);
	QCOMPARE( bd.white(14), 0 );		//	obNM
	QCOMPARE( bd.white(13), 0 );

}
void TestMiniBoard::benchRandomGame3()
{
#ifdef _DEBUG
	const int N_LOOP = 100;
#else
	const int N_LOOP = 100;
#endif
	int gameCount = 0;
	int turnCount = 0;
	int mvsCount = 0;
	QBENCHMARK_ONCE {
		for(int i = 0; i < N_LOOP; ++i) {
			++gameCount;
			Board bd("G B2. . W3. W2. B3W3. B2. B3. . W2 G");	//	
			bool blackTurn = true;
			for(bool init = true;;) {
				//qDebug() << bd.position();
				if( blackTurn )
					bd.swapBW();
				int d1, d2;
				do {
					d1 = (qrand() % 4) + 1;
					d2 = (qrand() % 4) + 1;
				} while( init && d1 == d2 );
				init = false;
				//QString text = bd.position();
				//Board bd2(bd);
				QList<Moves> mvsList = bd.whiteMovesList3(d1, d2);
				//if( bd.nBlack() != N_PIECE || bd.nWhite() != N_PIECE )
				//	mvsList = bd2.whiteMovesList3(d1, d2);
				Q_ASSERT( bd.nBlack() == N_PIECE );
				Q_ASSERT( bd.nWhite() == N_PIECE );
				QString pos = bd.position();
				if( !mvsList.isEmpty() ) {
					mvsCount += mvsList.size();
					++turnCount;
					QList<Move> mvs = mvsList[qrand() % mvsList.size()];
					foreach(Move mv, mvs)
						bd.moveWhite(mv);
				}
				if( blackTurn )
					bd.swapBW();
				if( bd.doesBlackWin() || bd.doesWhiteWin() ) break;
				blackTurn = !blackTurn;
			}
		}
	}
	qDebug() << "gameCount = " << gameCount;
	qDebug() << "ave turn count = " << (double)turnCount / gameCount;
	qDebug() << "ave mvs count = " << (double)mvsCount / turnCount;
}
void TestMiniBoard::benchEval5Play1()
{
	double eval;
	QBENCHMARK {
		Board bd("G B2. . W3. W2. B3W3. B2. B3. . W2 G");	//	
		int d1 = 3;		//(qrand() % 4) + 1;
		int d2 = 4;		//(qrand() % 4) + 1;
		QList<Move> mvs = bd.whiteMovesEval5PlyD(1, d1, d2, eval);	//	1ǂ݁{eval5()
	}
	qDebug() << "terminalNodeCount = " << terminalNodeCount();
}
void TestMiniBoard::benchEval5Play2()
{
	double eval;
	QBENCHMARK {
		Board bd("G B2. . W3. W2. B3W3. B2. B3. . W2 G");	//	
		int d1 = 3;	//(qrand() % 4) + 1;
		int d2 = 4;	//(qrand() % 4) + 1;
		QList<Move> mvs = bd.whiteMovesEval5PlyD(2, d1, d2, eval);	//	2ǂ݁{eval5()
	}
	qDebug() << "terminalNodeCount = " << terminalNodeCount();
}
void TestMiniBoard::benchEval5Play3()
{
	double eval;
	QBENCHMARK_ONCE {
		Board bd("G B2. . W3. W2. B3W3. B2. B3. . W2 G");	//	
		int d1 = 3;	//(qrand() % 4) + 1;
		int d2 = 4;	//(qrand() % 4) + 1;
		QList<Move> mvs = bd.whiteMovesEval5PlyD(3, d1, d2, eval);	//	3ǂ݁{eval5()
	}
	qDebug() << "terminalNodeCount = " << terminalNodeCount();
}
void TestMiniBoard::testEval5()
{
	{
		//        "G W3W3W2. . W1. . . B2B2B2. . W1B4 G"
		Board bd1("G W3W3W2. . W1. . . B2B2B2W1. . B4 G");		//	Z~vCɋ߂Â
		Board bd2("G W3W3W3. . . . . . B2B2B2. . W1B4 G");
		QVERIFY( bd1.eval5() > bd2.eval5() );
	}
	if( 0 ) {
		//        "G B1W4W2W2. . W1. B1. . B1W1B2B3B2 G"
		Board bd1("B2W2W2W2W2. . W1. B1. W1. . B2B3B2 G");		//	N[YAEg
		Board bd2("B2B1W4W2W2. . W1. W1. . . . B2B3B2 G");		//	O̐΂qbg
		QVERIFY( bd1.eval5() > bd2.eval5() );
	}
}
void TestMiniBoard::testEval6()
{
	{
		//        "G W3W3W2. . W1. . . B2B2B2. . W1B4 G"
		Board bd1("G W3W3W2. . W1. . . B2B2B2W1. . B4 G");		//	Z~vCɋ߂Â
		Board bd2("G W3W3W3. . . . . . B2B2B2. . W1B4 G");
		QVERIFY( bd1.eval6() > bd2.eval6() );
	}
	{
		//        "G B1W4W2W2. . W1. B1. . B1W1B2B3B2 G"
		Board bd1("B2W2W2W2W2. . W1. B1. W1. . B2B3B2 G");		//	N[YAEg
		Board bd2("B2B1W4W2W2. . W1. W1. . . . B2B3B2 G");		//	O̐΂qbg
		QVERIFY( bd1.eval6() > bd2.eval6() );
	}
	{
		//        "G B2W2. W3W3W2. . . . . . . . . B8 G"
		Board bd1("G B2W2W2W1W3W1. . . . . . . . . B8 G");		//	make vC
		Board bd2("G B2W3. W3W3W1. . . . . . . . . B8 G");		//	Ōړ
		QVERIFY( bd1.eval6() > bd2.eval6() );
	}
	{
		//        "G B2. . W3W2W2W1. . . . B2B3. B3W2 G"
		Board bd1("G B2. W1W3W2W2. . . . . B2B3W2B3.  G");		//	obN}ړ
		Board bd2("G B2W3. . W3W2. . . . . B2B3. B3W2 G");		//	ubN
		QVERIFY( bd1.eval6() > bd2.eval6() );
	}
}
//	_ vs eval5+1ǂ
void statsRollout_Random_EvalXPly1(EVAL_FUNC evalFunc, const QString &evalFuncName)
{
	qsrand((int)time(0));
	double eval;
	int randomWin = 0;
	int evalXWin = 0;
#ifdef _DEBUG
	const int N_LOOP = 40;
#else
	const int N_LOOP = 200;
#endif
	for(int i = 0; i < N_LOOP; ++i) {
		Board bd("G B2. . W3. W2. B3W3. B2. B3. . W2 G");	//	
		bool randomTurn = !(i & 1);
		for(;;) {
			int d1 = (qrand() % 3) + 1;
			int d2 = (qrand() % 3) + 1;
			if( randomTurn ) {
				bd.swapBW();
				QList<Move> mvs = bd.whiteMovesRandom(d1, d2);
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				bd.swapBW();
				if( bd.doesBlackWin() ) {
					++randomWin;
					break;
				}
			} else {
				QList<Move> mvs = bd.whiteMovesEvalXPlyD(1, d1, d2, eval, evalFunc);	//	1ǂ݁{evalFunc()
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				if( bd.doesWhiteWin() ) {
					++evalXWin;
					break;
				}
			}
			randomTurn = !randomTurn;
		}
	}
	qDebug() << evalFuncName << "ply-1 = " << evalXWin << "(" << evalXWin * 100 / (double)N_LOOP << "%)";
	qDebug() << "randomWin = " << randomWin << "(" << randomWin * 100 / (double)N_LOOP << "%)";
}
void TestMiniBoard::statsRollout_Random_Eval5Ply1()
{
	statsRollout_Random_EvalXPly1(::eval5, "eval5");
}
void TestMiniBoard::statsRollout_Random_Eval6Ply1()
{
	statsRollout_Random_EvalXPly1(::eval6, "eval6");
}
//	eval5+1ǂ vs eval5+1ǂ
void TestMiniBoard::statsRollout_Eval6Ply1_Eval5Ply1()
{
	qsrand((int)time(0));
	double eval;
	int eval6Win = 0;
	int eval5Win = 0;
#ifdef _DEBUG
	const int N_LOOP = 100;
#else
	const int N_LOOP = 1000;
#endif
	for(int i = 0; i < N_LOOP; ++i) {
		Board bd("G B2. . W3. W2. B3W3. B2. B3. . W2 G");	//	
		bool bTurn = !(i & 1);
		for(;;) {
			int d1 = (qrand() % 3) + 1;
			int d2 = (qrand() % 3) + 1;
			if( bTurn ) {
				bd.swapBW();
				QList<Move> mvs = bd.whiteMovesEvalXPlyD(1, d1, d2, eval, ::eval6);	//	1ǂ݁{eval6()
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				bd.swapBW();
				if( bd.doesBlackWin() ) {
					++eval6Win;
					break;
				}
			} else {
				QList<Move> mvs = bd.whiteMovesEval5PlyD(1, d1, d2, eval);	//	1ǂ݁{eval5()
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				if( bd.doesWhiteWin() ) {
					++eval5Win;
					break;
				}
			}
			bTurn = !bTurn;
		}
	}
	qDebug() << "eval6 ply-1 = " << eval6Win << "(" << eval6Win * 100 / (double)N_LOOP << "%)";
	qDebug() << "eval5 ply-1 = " << eval5Win << "(" << eval5Win * 100 / (double)N_LOOP << "%)";
}
