#include <QPushButton>
#include <QMessageBox>
#include "StatisticsDlg.h"

class NumericTableWidgetItem : public QTableWidgetItem
{
public:
	NumericTableWidgetItem(const QString &text)
		: QTableWidgetItem(text)
	{}

public:
	bool operator<(const QTableWidgetItem &x) const
	{
		return text().toDouble() < x.text().toDouble();
	}
};

StatisticsDlg::StatisticsDlg(QWidget *parent)
	: QDialog(parent)
{
	ui.setupUi(this);
	QPushButton *ok = ui.buttonBox->button(QDialogButtonBox::Ok);
	ok->setDefault(true);
	ok->setFocus(Qt::OtherFocusReason);
	QPushButton *reset = ui.buttonBox->button(QDialogButtonBox::Reset);
	connect(reset, SIGNAL(clicked()), this, SLOT(onReset()));

	QStringList lst;
	lst << "" << "Rating" << "Point" << "win" << "game" << "win %";
	ui.table->setHorizontalHeaderLabels(lst);
}

StatisticsDlg::~StatisticsDlg()
{
}
void StatisticsDlg::updateText()
{
	ui.table->setRowCount(0);
	QList<QStringList> lst;
	emit statisticsTextList(lst);
	foreach(const QStringList &sl, lst) {
		if( sl.size() >= 5 )
			addRow(sl);
	}
#if 0
	QString text;
	emit statisticsText(text);
	setText(text);
#endif
}
void StatisticsDlg::setText(const QString &text)
{
	//ui.label->setText(text);
}
void StatisticsDlg::addRow(const QStringList &lst)
{
	int row = ui.table->rowCount();
	ui.table->insertRow(row);
	//ui.table->setRowCount(row + 1);
	for(int i = 0; i < 6; ++i) {
		NumericTableWidgetItem *item = new NumericTableWidgetItem(lst[i]);
		item->setFlags(Qt::NoItemFlags);
		item->setTextAlignment(Qt::AlignRight);
		ui.table->setItem(row, i, item);
	}
}
#if 0
void StatisticsDlg::addRow(const QString &name, const QString &rating,
							const QString &win,
							const QString &game,
							const QString &winPercent)
{
	int row = ui.table->rowCount();
	ui.table->setRowCount(row + 1);
	QTableWidgetItem *item;
	ui.table->setItem(row, 0, item = new QTableWidgetItem(name));
	item->setFlags(Qt::NoItemFlags);
	ui.table->setItem(row, 1, item = new QTableWidgetItem(rating));
	item->setFlags(Qt::NoItemFlags);
	ui.table->setItem(row, 2, item = new QTableWidgetItem(win));
	item->setFlags(Qt::NoItemFlags);
	ui.table->setItem(row, 3, item = new QTableWidgetItem(game));
	item->setFlags(Qt::NoItemFlags);
	ui.table->setItem(row, 4, item = new QTableWidgetItem(winPercent));
	item->setFlags(Qt::NoItemFlags);
}
#endif
void StatisticsDlg::onReset()
{
	if( QMessageBox::question(this, qApp->applicationName(), tr("Are You Sure to Clear Statistics ?"),
								QMessageBox::Yes | QMessageBox::No)
				== QMessageBox::Yes )
	{
		emit clearStatistics();
		updateText();
	}
}
