#include "NewGameDlg.h"

NewGameDlg::NewGameDlg(QWidget *parent)
	: QDialog(parent)
{
	ui.setupUi(this);
	ui.HumanVsComp->setChecked(true);
	ui.CompRandom->setChecked(true);
	ui.Comp2Random->setChecked(true);
}

NewGameDlg::~NewGameDlg()
{

}
int NewGameDlg::gameMode() const
{
	if( ui.HumanVsComp->isChecked() ) return 0;
	if( ui.CompVsComp->isChecked() ) return 1;
	return -1;
}
int NewGameDlg::compType() const
{
	if( ui.CompRandom->isChecked() ) return 0;
	if( ui.CompBeginner->isChecked() ) return 1;
	if( ui.CompIntermediate->isChecked() ) return 2;
	if( ui.CompAdvanced->isChecked() ) return 3;
	return -1;
}
int NewGameDlg::comp2Type() const
{
	if( ui.Comp2Random->isChecked() ) return 0;
	if( ui.Comp2Beginner->isChecked() ) return 1;
	if( ui.Comp2Intermediate->isChecked() ) return 2;
	if( ui.Comp2Advanced->isChecked() ) return 3;
	return -1;
}
void NewGameDlg::setGameMode(int v)
{
	switch( v ) {
	case 0:	ui.HumanVsComp->setChecked(true);	break;
	case 1:	ui.CompVsComp->setChecked(true);	break;
	}
}
void NewGameDlg::setCompType(int v)
{
	switch( v ) {
	case 0:	ui.CompRandom->setChecked(true);	break;
	case 1:	ui.CompBeginner->setChecked(true);	break;
	case 2:	ui.CompIntermediate->setChecked(true);	break;
	case 3:	ui.CompAdvanced->setChecked(true);	break;
	}
}
void NewGameDlg::setComp2Type(int v)
{
	switch( v ) {
	case 0:	ui.Comp2Random->setChecked(true);	break;
	case 1:	ui.Comp2Beginner->setChecked(true);	break;
	case 2:	ui.Comp2Intermediate->setChecked(true);	break;
	case 3:	ui.Comp2Advanced->setChecked(true);	break;
	}
}
