﻿Option Explicit On
Option Strict On

''' <summary>設定情報クラス。</summary>
''' <remarks>
''' このランチャーの設定情報を格納する。
''' </remarks>
Public NotInheritable Class SettingParameter

    ' 背景色を表す文字列
    Private mBackColor As String

    ' クリック後の動作設定
    Private mClickAfter As Boolean

    ' 自動隠しモード
    Private mAutoHideMode As Integer

    ' タスクバー表示モード
    Private mTaskBar As Boolean

    ''' <summary>コンストラクタ。</summary>
    Public Sub New()
        Me.mBackColor = "0,54,173"
        Me.mClickAfter = True
        Me.mAutoHideMode = 0
        Me.mTaskBar = True
    End Sub

    ''' <summary>コンストラクタ。</summary>
    ''' <param name="root">ルート要素。</param>
    Public Sub New(root As XElement)
        Me.mBackColor = root.Element("backColor").Value
        Me.mClickAfter = Boolean.Parse(root.Element("hideClickAfter").Value)
        Me.mAutoHideMode = Integer.Parse(root.Element("autoHideMode").Value)
        Me.mTaskBar = Boolean.Parse(root.Element("taskBar").Value)
    End Sub

    ''' <summary>設定情報を XMLに書き込む。</summary>
    ''' <param name="root">ルート要素。</param>
    Public Sub Save(root As XElement)
        root.SetElementValue("backColor", Me.mBackColor)
        root.SetElementValue("hideClickAfter", Me.mClickAfter.ToString())
        root.SetElementValue("autoHideMode", Me.mAutoHideMode.ToString())
        root.SetElementValue("taskBar", Me.mTaskBar.ToString())
    End Sub

#Region "properties"

    ''' <summary>背景色設定。</summary>
    ''' <value>Color型。</value>
    Public Property BackColor() As Color
        Get
            Dim clrs() As String = Me.mBackColor.Split(","c)
            Return Color.FromRgb(Byte.Parse(clrs(0)),
                                 Byte.Parse(clrs(1)),
                                 Byte.Parse(clrs(2)))
        End Get
        Set(value As Color)
            With value
                Me.mBackColor = String.Format("{0},{1},{2}", .R, .G, .B)
            End With
        End Set
    End Property

    ''' <summary>クリック後、ウィンドウを最小化する。</summary>
    ''' <value>真偽値。</value>
    Public Property HideClickAfter() As Boolean
        Get
            Return Me.mClickAfter
        End Get
        Set(value As Boolean)
            Me.mClickAfter = value
        End Set
    End Property

    ''' <summary>自動隠しモード。</summary>
    ''' <value>整数値。</value>
    Public Property AutoHideMode() As Integer
        Get
            Return Me.mAutoHideMode
        End Get
        Set(value As Integer)
            Me.mAutoHideMode = value
        End Set
    End Property

    ''' <summary>タスクバー表示モード。</summary>
    ''' <value>真偽値。</value>
    Public Property ShowTaskbar() As Boolean
        Get
            Return Me.mTaskBar
        End Get
        Set(value As Boolean)
            Me.mTaskBar = value
        End Set
    End Property

#End Region

End Class
