﻿Option Strict On
Option Explicit On

Imports System.Runtime.InteropServices
Imports System.Windows.Interop

Public NotInheritable Class DragAdorner
    Inherits Adorner

    <StructLayout(LayoutKind.Sequential, charset:=CharSet.Auto)> _
    Public Structure PointWin32
        Public x As UInteger
        Public y As UInteger
    End Structure

    <DllImport("user32.dll")>
    Public Shared Sub GetCursorPos(ByRef pt As PointWin32)

    End Sub

    <DllImport("user32.dll")>
    Public Shared Function ScreenToClient(hWnd As IntPtr, ByRef pt As PointWin32) As Integer

    End Function

    Public Shared Function GetNowPosition(v As Visual) As Point
        Dim p As PointWin32
        GetCursorPos(p)

        Dim src As HwndSource = CType(HwndSource.FromVisual(v), HwndSource)
        ScreenToClient(src.Handle, p)
        Return New Point(p.x, p.y)
    End Function

    Private adornerChild As Image

    Private mLf As Double, mTp As Double

    Public Sub New(adornedElement As UIElement, dragImage As ImageSource)
        MyBase.New(adornedElement)
        adornerChild = New Image()
        adornerChild.Width = 48
        adornerChild.Height = 48
        adornerChild.Source = dragImage
        adornerChild.Opacity = 0.5
    End Sub

    Protected Overrides Function MeasureOverride(constraint As Size) As Size
        adornerChild.Measure(constraint)
        Return adornerChild.DesiredSize
    End Function

    Protected Overrides Function ArrangeOverride(finalSize As Size) As Size
        adornerChild.Arrange(New Rect(finalSize))
        Return finalSize
    End Function

    Protected Overrides ReadOnly Property VisualChildrenCount As Integer
        Get
            Return 1
        End Get
    End Property

    Protected Overrides Function GetVisualChild(index As Integer) As Visual
        Return adornerChild
    End Function

    Private Sub UpdatePosition()
        Dim adornerLayer As AdornerLayer = CType(Me.Parent, Documents.AdornerLayer)
        If adornerLayer IsNot Nothing Then
            adornerLayer.Update(AdornedElement)
        End If
    End Sub

    Public Overrides Function GetDesiredTransform(transform As GeneralTransform) As GeneralTransform
        Dim result As New GeneralTransformGroup()
        result.Children.Add(MyBase.GetDesiredTransform(transform))
        result.Children.Add(New TranslateTransform(Me.Left, Me.Top))
        Return result
    End Function

    Public Property Left() As Double
        Get
            Return Me.mLf
        End Get
        Set(value As Double)
            Me.mLf = value
            UpdatePosition()
        End Set
    End Property

    Public Property Top() As Double
        Get
            Return Me.mTp
        End Get
        Set(value As Double)
            Me.mTp = value
            UpdatePosition()
        End Set
    End Property

End Class

