﻿Option Explicit On
Option Strict On

Imports System.IO

''' <summary>データコレクション。</summary>
''' <remarks>
''' メインウィンドウで使用するデータを管理するコレクション。
''' </remarks>
Public NotInheritable Class Collection

    ' 設定情報
    Private mSettings As SettingParameter

    ' アイコン情報格納
    Private mPageIcons As IconCollection

    ''' <summary>アプリケーション用のXMLデータファイルを読み込む。</summary>
    ''' <remarks>
    ''' アプリケーション用のデータファイルを読み込む。
    ''' ファイルがなければ初期値で作成する。
    ''' </remarks>
    Public Sub LoadXMLFile()
        If Not File.Exists(Application.XML_FILE_PATH) Then
            ' ファイルがなければ初期値で生成
            Me.mSettings = New SettingParameter()
            Me.mPageIcons = New IconCollection()
            Directory.CreateDirectory(Application.APPDATA_PATH)
            Me.SaveXMLFile()
        Else
            ' ファイルがあるので読み込む
            Dim doc As XDocument = XDocument.Load(Application.XML_FILE_PATH)
            Me.mSettings = New SettingParameter(doc.<launcher>(0))
            Me.mPageIcons = New IconCollection(doc.<launcher>(0), -1)
        End If
    End Sub

    ''' <summary>データコレクションの内容をファイルに出力する。</summary>
    Public Sub SaveXMLFile()
        If Me.mSettings IsNot Nothing Then
            Dim doc As New XDocument()
            Dim root As New XElement("launcher")

            Me.mSettings.Save(root)
            Me.mPageIcons.Save(root)

            doc.Add(root)
            doc.Save(Application.XML_FILE_PATH)
        End If
    End Sub

#Region "properties"

    ''' <summary>設定情報を取得する。</summary>
    ''' <value>SettingParameter型。</value>
    Public ReadOnly Property Settings() As SettingParameter
        Get
            Return Me.mSettings
        End Get
    End Property

    ''' <summary>ページコレクションを取得する。</summary>
    ''' <value>IconCollection型。</value>
    Public ReadOnly Property PageIcons() As IconCollection
        Get
            Return Me.mPageIcons
        End Get
    End Property

#End Region

End Class
