/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

// reference
var Config			= window.h5glib.Config;
var Debug			= window.h5glib.Debug;
var Command			= window.h5glib.Command;
var Task			= window.h5glib.Task;
var SoundTask		= window.h5glib.SoundTask;
var Message			= window.h5glib.Message;
var MessageHandler	= window.h5glib.MessageHandler;
var MessageManager	= window.h5glib.MessageManager;
var SceneStatus		= window.h5glib.SceneStatus;
var Scene			= window.h5glib.Scene;

var StageScene		= window.h5glib.StageScene;
var EventScene		= window.h5glib.EventScene;

/**
 * Res
 */
var Res =
{
	String :
	{
		HTML_USAGE		: "<p>" +
						  "＜キー入力ができない場合はゲームの画面をクリックしてみてください＞<br>" +
						  "[↑][↓]: 選択 [Enter]: ゲーム開始" +
						  "</p>",
		TM_MENUCAPTION	: "Menu",
		ID_MESSAGE		: "message"
	},
	Color :
	{
		PANEL			: "darkslategray",
		BUTTON			: "cadetblue",
		BUTTON_FOCUS	: "skyblue",
		BORDER			: "rgb(255, 255, 255)",
		TEXT			: "rgb(255, 255, 255)"
	},
	Font :
	{
		LARGE		: "bold 18px 'ＭＳ Ｐゴシック'",
		SMALL		: "bold 14px 'ＭＳ Ｐゴシック'"
	}
};

/**
 * MessageType
 */
var MessageType =
{
	NONE		: 0,
	START_GAME	: 1
};

var Selections	= 
[
	{ text : "QV RPG",			baseUrl : "event0",	func : EventScene, pfunc : StageScene }
];

/**
 * MenuTask
 */
var MenuTask = function( scene )
{
	this.command	= scene.command;	// input

	this.select		= 0;
	this.lag		= this.LAG_VAL;
};
MenuTask.prototype = new Task();

(function( pt )
{
	pt.LAG_VAL		= 5;

	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd			= false;
		var msgManager	= scene.msgManager;

		if ( this.lag > 0 )
		{
			this.lag--;
		}
		else
		{
			if ( this.command.tbl.up )
			{
				this.select--;
				if ( this.select < 0 )
				{
					this.select = Selections.length - 1;
				}
				this.lag = this.LAG_VAL;
				upd = true;
			}
			else if ( this.command.tbl.down )
			{
				this.select++;
				if ( this.select >= Selections.length )
				{
					this.select = 0;
				}
				this.lag = this.LAG_VAL;
				upd = true;
			}
			else if ( this.command.tbl.enter )
			{
				var selection	= Selections[ this.select ];
				var message		= new Message( MessageType.START_GAME );
				message.data.baseUrl	= selection.baseUrl;
				message.data.func		= selection.func;
				message.data.pfunc		= selection.pfunc;
				msgManager.postBreakMessage( message );
			}
		}
		return upd;
	};
	/**
	 * 描画する。
	 */
	pt.draw = function( scene )
	{
		var context		= scene.context;
		var canvas		= context.canvas;

		context.save();

		// clear background
		context.fillStyle = Res.Color.PANEL;
		context.fillRect( 0, 0, canvas.width, canvas.height );

		// draw caption
		var cx	= 100;
		var cy	= 20;
		context.font		= Res.Font.LARGE;
		context.fillStyle	= Res.Color.TEXT;
		context.fillText( Res.String.TM_MENUCAPTION, cx, cy + 24 );

		// draw Selections
		var bx	= 50;
		var by	= 80;
		var bw	= canvas.width - ( bx * 2 );
		var bh	= 40;
		for ( var i = 0; i < Selections.length; i++ )
		{
			var color	= ( this.select == i ) ? Res.Color.BUTTON_FOCUS : Res.Color.BUTTON;
			// rect
			context.fillStyle	= color;
			context.fillRect( bx, by, bw, bh );
			// border
			context.strokeStyle	= Res.Color.BORDER;
			context.beginPath();
			context.strokeRect( bx, by, bw, bh );
			// text
			context.font		= Res.Font.SMALL;
			context.fillStyle	= Res.Color.TEXT;
			context.fillText( Selections[i].text, bx + 10, by + 22 );
			// inc by
			by	+= ( bh + 10 );
		}
		context.restore();
	};
})( MenuTask.prototype );

/**
 * InputCommand
 */
var InputCommand = function()
{
	this.tbl.left	= 0;
	this.tbl.right	= 0;
	this.tbl.up		= 0;
	this.tbl.down	= 0;
	this.tbl.enter	= 0;
	this.tbl.escape	= 0;
};
InputCommand.prototype = new Command();

(function( pt )
{
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		var type = event.type.toLowerCase();
		if ( type.substring( 0, 3 ) == "key" )
		{
			var value = 0;
			if      ( type == "keydown" ) { value = 1; }
			else if ( type == "keyup"   ) { value = 0; }

			switch ( event.keyCode )
			{
				case 37: this.tbl.left	= value; event.prevent( event.orgEvent ); break;	// ←
				case 39: this.tbl.right	= value; event.prevent( event.orgEvent ); break;	// →
				case 38: this.tbl.up	= value; event.prevent( event.orgEvent ); break;	// ↑
				case 40: this.tbl.down	= value; event.prevent( event.orgEvent ); break;	// ↓
				case 13: this.tbl.enter	= value; break;	// ENTER
				case 27: this.tbl.escape= value; break;	// ESC
			}
		}
	};
})( InputCommand.prototype );

/**
 * MenuScene
 */
var MenuScene = function( app, name )
{
	this.app		= app;
	this.name		= name;
	this.stageName	= null;

	this.command	= new InputCommand();

	this.menuTask	= new MenuTask( this );
	// head of task list
	this.child		= this.menuTask;
	this.setStatus( SceneStatus.RUNNING );

	// message handler
	this.msgManager	= new MessageManager();
	this.msgManager.addHandler( new MessageHandler( MessageType.START_GAME,	this, this.handleStartGame ) );
};
MenuScene.prototype = new Scene();

(function( pt )
{
	/**
	 * 
	 */
	pt.handleStartGame = function( scene, message )
	{
		var baseUrl		= message.data.baseUrl;
		var gameScene	= this.app.sceneManager.push( baseUrl );
		if ( gameScene )
		{
			gameScene.setStatus( SceneStatus.RUNNING );
			gameScene.show();
		}
		else
		{
			var func	= message.data.func;
			var pfunc	= message.data.pfunc;
			// create scene
			gameScene	= new func( this.app, baseUrl, pfunc );

			this.app.sceneManager.add( gameScene );
			this.app.sceneManager.push( gameScene.name );

			gameScene.init();
			gameScene.show();

			// load data
			var base = ( baseUrl.charAt( baseUrl.length - 1 ) == '/' ) ? baseUrl : baseUrl + '/';
			this.app.loadScript( base + Config.dataJSName );
		}
	};
	/**
	 * 
	 */
	pt.init = function()
	{
		// window.onload のタイミング
	};
	/**
	 * 
	 */
	pt.show = function()
	{
		this.setUsage( Res.String.HTML_USAGE );
		this.command.clear();

		this.holdContext();
		this.draw( this );
	};
})( MenuScene.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }
window.h5glib.MenuScene		= MenuScene;


// Anonymous function end
//
})( window );
