
function createAudio(name)
{
	//拡張子も含めて指定
	return new Audio(URL_PCD_Audio + name);
}

function createImage(name)
{
	//拡張子も含めて指定
	var img = document.createElement('img');
	img.src = "./images/" + name;
	return img;
}

function createCanvas(id, width, height, x, y, z, parent)
{
	//識別名idで
	//width * heightの大きさのCanvasを
	//(x,y,z)に生成する。
	//parentには、Canvasタグを包含することになるDOMオブジェクトのidを指定する。
	var canvas = document.createElement("canvas");

	canvas.id = id;
	
	parent.appendChild(canvas);

	canvas.style.position = "absolute";
	canvas.style.top = y + "px";
	canvas.style.left = x + "px";
	canvas.style.zIndex = z;

	canvas.width = width;
	canvas.height = height;

	return canvas;
}

//parent にまMainAreaを指定。nullにした場合は後で手動で追加する
function createMessageBox(id, width, height, x, y, parent, color, foreColor, margin)
{
	if(color == undefined) color = "#000";
	if(foreColor == undefined) foreColor = "#fff";
	if(margin == undefined) margin = 16;
	
	var base = document.createElement("div");
	base.style.opacity = "0.7";
	base.style.top = y + "px";
	base.style.left = x + "px";
	base.style.backgroundColor = color;
	base.style.color = foreColor;
	base.style.position = "absolute";
	base.style.border = "1px " + foreColor + " solid";
	base.style.overflow = "hidden";
	base.style.fontSize = "24px";
	base.style.width = width + "px";
	base.style.height = height + "px";
	base.style.zIndex = "100";
	base.id = id;
	
	var p = document.createElement("div");
	p.style.position = "absolute";
	p.style.padding = margin + "px";
	p.style.width = (width - (margin * 2)) + "px";
	p.style.bottom = "0";
	p.style.wordBreak = "break-all";
	p.className = "messageBoxInside";
	base.appendChild(p);
	
	var ar = document.createElement("div");
	ar.style.position = "absolute";
	ar.style.bottom = "0";
	ar.style.right = "0";
	ar.style.padding = "4px";
	//ar.style.width = "24px";
	//ar.style.height = "16px";
	ar.innerText = "▼";
	ar.className = "messageBoxArrow";
	base.appendChild(ar);
	
	if(parent)
	{
		parent.appendChild(base);
	}
	return base;
}

function changeMessageBox(box, message, showArrow)
{
	if(showArrow == undefined) showArrow = false;
	for(var i = 0; i < box.childNodes.length; i++)
	{
		var element = box.childNodes[i];
		if(element.className == "messageBoxInside")
		{
			element.innerText = message;
			//element.style.top = (parseInt(box.style.height.slice(0, box.style.height.length - 2)) - parseInt(element.style.height.slice(0, element.style.height.length - 2))) + "px";	//"px"は削除される
			//console.log(box.style.height.slice(0, box.style.height.length - 2) + "  " + element.style.height.slice(0, element.style.height.length - 2));
			
		}else if(element.className == "messageBoxArrow")
		{
			element.style.display = (showArrow && mainManager.tickCount % 30 < 15) ? "block" : "none";
		}
	}
}

function createDOMObject(typestr, idstr, parentidstr)
{
	dobj = document.createElement(typestr);
	parentObj = document.getElementById(parentidstr);
	
	dobj.id = idstr;
	parentObj.appendChild(dobj);
	
	for(;;){
		if(document.getElementById(idstr)){
			break;
		}
	}
	
	return dobj;
}

function destroyDOMObjectByID(id)
{
	//識別名idのDOMオブジェクトを破棄する。
	object = document.getElementById(id);
	parentObj = object.parentNode;

	parentObj.removeChild(object);
}

function removeObjectFromArray(anArray, anObject)
{
	var ret = false;
	//anArray中にある全てのanObjectを削除し、空いた部分は前につめる。
	for(var i = 0; i < anArray.length; i++){
		if(anArray[i] == anObject){
			anArray.splice(i, 1);
			ret = true;
			i--;
		}
	}
	return ret;
}

function removeAnObjectFromArray(anArray, anObject)
{
	var ret = false;
	//anArray中にある最初のanObjectを削除し、空いた部分は前につめる。
	for(var i = 0; i < anArray.length; i++){
		if(anArray[i] == anObject){
			anArray.splice(i, 1);
			ret = true;
			break;
		}
	}
	return ret;
}

function parseArrayToStringSource(anArray){
	//戻り値をevalすると等価なオブジェクトを得ることができる。
	//parseArrayToStringSource({1,"321a","abc",test:["cder","",554]});
	//parseArrayToStringSource([1,"321a","abc",{a:"cder",0:"",1:554}]);
	if(!anArray){
		return "null";
	}

	var srcstr = "var t=";
	
	srcstr += parseArrayToStringSource_Sub(anArray);
	
	srcstr += ";t;";
	
	return srcstr;
}

function parseArrayToStringSource_Sub(anArray){
	if(!anArray){
		return "null";
	}

	var srcstr = "{";
	
	for(var k in anArray){
		var v = anArray[k];
		var t = Object.prototype.toString.call(v);
		if(v instanceof Array){
			srcstr += k + ":" + parseArrayToStringSource_Sub(v) + ",";
		} else if(!isNaN(v) && v.toString().replace(/\s+/g, "").length > 0){
			//isNaNだけでは数値判定できないので、文字列化後の空白文字を削除した長さも検査している。
			srcstr += k + ":" + v + ",";
		} else if(t == "[object String]"){
			//文字列として変換
			srcstr += k + ":'" + v + "',";
		} else if(t == "[object Object]"){
			srcstr += k + ":" + parseArrayToStringSource_Sub(v) + ",";
		} else{
			srcstr += k + ":undefined,";
		}
	}

	if(srcstr.charAt(srcstr.length - 1) == ","){
		//最後の余計なカンマを削除
		srcstr = srcstr.slice(0, srcstr.length - 1);
	}
	srcstr += "}";
	
	return srcstr;
}

function isValidResponseText(res)
{
	//phpからのレスポンスにエラーが含まれていないかをチェックする。
	if(res.indexOf("Warning") == -1){
		if(res.indexOf("error") == -1){
			return true;
		}
	}
	alert("サーバースクリプトがエラーを返しました。:" + res);
	mainManager.stopStage();
	return false;
}

function getRandomInteger(max){
	return Math.floor(Math.random() * max+1)
}

//赤色の忠告ボックスを表示
function showAlert(manager, message)
{
	var w = new TextWidgetClass(manager, [message, false, false, false, 'red']);
	w.wBox.style.height = 64 + "px";
	w.wBox.style.top = 406 + "px";
	manager.addWidget(w);
	window.setTimeout(function(){manager.removeWidget(w)}, 500);
}
