var OperatedCharacterClass = function(ownerStage, args){
	OperatedCharacterClass.base.apply(this, arguments);
	
	//̒lieLN^[jqNX㏑邱ƂŌ𐶂ݏo
	this.movingVelocity = 200;
	this.jumpPower_tickCountBase = 15;
	this.jumpPower_tickCountAtLeast = 2;
	this.jumpPower_tickCount = 0;
	this.jumpPower = 110;
	this.jumpSound = createAudio("jump12.mp3");
	this.collisionMargin.top = 2;
	this.collisionMargin.left = 10;
	this.collisionMargin.right = 10;
	this.collisionMargin.bottom = 2;
	
	this.isGround = false;
	
}.extend(CharacterClass, {
	className: "OperatedCharacterClass",
	//ɃL̓ɑ΂鐧ȂQ(ړAUȂ)LqB
	//LƂɐς̂ł΂this.xxxCX^XϐɋLqAgNXł̒l㏑ׂłB
	//]Ă̎qNXthis.movingSpeedȂǂ̂͂ӂ킵ȂƍlB
	
	// ʏ퍶ɐiނƂɌĂ΂BL[ĂԒtickɌĂ΂
	goLeft : function(){
		this.imageState = 0;
		this.movingSpeed.x += ((-this.movingVelocity) - this.movingSpeed.x) / 3;
	},
	
	//ʏEɐiނƂɌĂ΂B
	goRight : function(){
		this.imageState = 0;
		this.movingSpeed.x += (this.movingVelocity - this.movingSpeed.x) / 3;
	},
	
	//ʏWvƂɌĂ΂BWvL[ĂԂ͂ƌĂ΂
	//WvL[Ă鎞Ԃ̒ɉăWv̍ωB
	jump : function(){
		if(this.jumpPower_tickCount == 0 && (this.isGround || this.inWater)){
			//Wv̏
			this.jumpEnd = OperatedCharacterClass.prototype.jumpEnd;
			this.jumpPower_tickCount = this.jumpPower_tickCountBase;
		}
		if(this.jumpPower_tickCount > 0){
			if(this.jumpPower_tickCount == this.jumpPower_tickCountBase){
				this.jumpSound.load();
				this.jumpSound.play();
			}
			this.jumpPower_tickCount--;
			var p = (this.jumpPower_tickCount / this.jumpPower_tickCountBase);
			if(this.movingSpeed.y <= this.movingVelocity){
				this.movingSpeed.y += -this.jumpPower * p * p;
			}
		}
	},
	objectAttacked : function(obj, obj_x, obj_y, direction)
	{
		if(!obj.isPhantom)
		{
			if((direction & CollideBottom) != 0)
			{
				this.isGround = true;
			}
		}
	},
	jumpEnd: function(){
		//WvL[ĂȂԂ͂炪ĂяoBWvׂďInullɂȂB
		//WvL[ZԉꍇłA̍܂ł̓Wv悤ɂ邽߁B
		if(this.jumpPower_tickCount < this.jumpPower_tickCountBase - this.jumpPower_tickCountAtLeast){
			this.jumpPower_tickCount = 0;
			this.jumpEnd = null;
		} else{
			this.jump();
		}
	},
	tick : function(){
		OperatedCharacterClass.base.prototype.tick.apply(this);	
	},
	draw : function(x, y){
		this.isGround = false;
		OperatedCharacterClass.base.prototype.draw.apply(this, [x, y]);
	}
});
