﻿var MainCharacterClass_Hunter = function(stage, args, isFromNetwork){
	MainCharacterClass_Hunter.base.apply(this, arguments);
}.extend(MainCharacterClass, {
	className: "MainCharacterClass_Hunter",
	create: function(stage, args){
		MainCharacterClass_Hunter.base.prototype.create.apply(this,[stage,[["bowman1.png","bowman2.png","bowman3.png","bowman4.png","bowman3.png","bowman2.png",],["bowman-aim.png","bowman-shot.png"]]]);
		this.size.x = 32;
		this.size.y = 64;
		this.movingVelocity = 200;
	},
	fire: function()
	{
		if(this.lastFireTick < this.ownerStage.manager.tickCount - this.fireTickInterval){
			var f = new FireObjectClass(this.ownerStage, [["arrow1.png"]]);
			if(this.ownerStage.manager.breadItemWidget)
			{
				var score = this.ownerStage.manager.breadItemWidget.getLastSelectedBreadIndex();
				if(score != -1)
				{
					f.maxBoundCount = 1;
					f.size.x = 32;
					f.size.y = 32;
					f.fireVelocity = new Point2D(1500, 0);
					f.antigravity = 700 / this.ownerStage.manager.tickPerSecond;
					f.fire(this, 32, 16);
					this.imageState = 1;
					this.imageIndex = 0;
					this.lastImage = this.imageList[this.imageState][this.imageIndex];
					
					this.lastFireTick = this.ownerStage.manager.tickCount;
				}else
				{
					showAlert(this.ownerStage.manager, "パンを選択してください。");
				}
			}
		}
	},
});
