var HiddenBlockClass = function(ownerStage, args)
{
	HiddenBlockClass.base.apply(this, arguments);
	var img = document.createElement('img');
	img.src = "images/" + args[0];
	//一時的に保存
	this.image0 = img;
	//画像はなし
	this.image = null;
	
	this.debugMode = true;
	
	this.isPhantom = true;
	
	//このフラグで立っているビットがすべて立っていればブロック出現と判定する。
	this.collidingMask = CollideBottom;
	this.collidingExcludeMask = CollideBody;
	this.lastCollidedTick = 0;
	this.collidedTickInterval = 10;
}.extend(BlockClass, {
	tick : function()
	{
		this.checkTouchingDirection();
		//console.log(this.touchingDirection.toString(2));
		if((this.touchingDirection & this.collidingMask) == this.collidingMask){
			if((this.touchingDirection & this.collidingExcludeMask) == 0){
				if(this.lastCollidedTick < this.ownerStage.manager.tickCount - this.collidedTickInterval){
					//当たっていたら画像を表示させて、さらにこの関数をベースクラスのものに戻す。
					this.isPhantom = false;
					this.image = this.image0;
					this.tick = BlockClass.prototype.tick;
					this.debugDraw = BlockClass.prototype.debugDraw;
				}  else{
					//違う方向からの衝突であればしばらく無視する
					this.lastCollidedTick = this.ownerStage.manager.tickCount;
				}
			} else{
				//違う方向からの衝突であればしばらく無視する
				this.lastCollidedTick = this.ownerStage.manager.tickCount;
			}
		}
	},
	
	debugDraw: function(x, y){
		//衝突マップに描画
		this.ownerStage.collisionMapContext.save();
		this.ownerStage.collisionMapContext.strokeStyle='rgba(0, 255, 0, 0.5)';
		strokeRect(this.ownerStage.collisionMapContext, x, y, this.size.x, this.size.y);
		this.ownerStage.collisionMapContext.restore();
	},
});