var BakingOvenObjectClass = function(ownerStage, args){
	BakingOvenObjectClass.base.apply(this, arguments);
	
	this.imgs = new Array();
	for(var i = 0; i < 3; i++){
		this.imgs[i] = document.createElement('img');
	}
	this.imgs[0].src = "images/furnace.png";
	this.imgs[1].src = "images/furnaceof1.png";
	this.imgs[2].src = "images/furnaceof2.png";
	
	this.img_puff = [];
	this.img_puff[0] = document.createElement('img');
	this.img_puff[0].src = "images/puff.png";
	this.img_puff[1] = document.createElement('img');
	this.img_puff[1].src = "images/puff2.png";
	
	this.cookSound = createAudio("baking.mp3");
	this.image = this.imgs[0];
	this.size.x = 64;
	this.size.y = 96;
	this.isPhantom = true;
	this.isSelecting = false;
	this.basePoint = 0;
	this.bakingTickCount = 0;
	this.bakingCount = 0;
	this.bakingStartTime = -1;		//調理開始時に時刻を代入
	this.isBaking = false;
	
	this.selectKeyPushed = false;
	
}.extend(BlockClass, {
	tick : function()
	{
		//this.checkTouchingDirection();
		//if((this.touchingDirection & CollideBody) == CollideBody){
		var c = this.ownerStage.userControlledCharacter;
		if(this.isOverlappedWithLocatedObject(c, c.origin.x, c.origin.y)){
			if(this.ownerStage.manager.UIManager.keyState.select && !this.isSelecting && !this.selectKeyPushed){
				this.selectKeyPushed = true;
				var that = this;
				var thatManager = that.ownerStage.manager;
				if(!this.isBaking){
					//焼き始め
					if(thatManager.userManager.ingredientList.length <= 0){
						thatManager.addWidget(new MessageWidgetClass(thatManager, ["手持ちの材料がありません！\n"]));
						that.isSelecting = false;
					} else if(!this.isSelecting){
						this.isSelecting = true;
						thatManager.addWidget(
							new SelectWidgetClass(thatManager, [thatManager.userManager.ingredientList, function(retv){
								if(retv != null){
									if(retv.length > 0){
										that.basePoint = that.calculateBreadBasePoint(retv);
										if(that.basePoint < 0){
											thatManager.addWidget(new MessageWidgetClass(thatManager, ["見るからにまずそう…焼くのはやめておこう。\n"]));
										} else{
											var text = new TextWidgetClass(thatManager, ["焼き始めました！\nもう一度窯を選択すると取り出します。       ", true, true]);
											thatManager.addWidget(text);
											that.bakingTickCount = 0;
											that.bakingCount = 0;
											that.bakingStartTime = +new Date();	//時間のミリ秒を代入
											that.isBaking = true;
											for(var i = 0, m = retv.length; i < m; i++){
												removeAnObjectFromArray(thatManager.userManager.ingredientList, retv[i]);
											}
											that.cookSound.load();
											that.cookSound.play();
										}
									} else{
										thatManager.addWidget(new MessageWidgetClass(thatManager, ["一つも材料が選択されていないので、パンを焼くことができません！\n"]));
									}
								}
								that.isSelecting = false;
							},true, 0, true])
						);
					}
				} else if(this.bakingCount > 10){
					//焼き終わり
					this.isSelecting = true;
					var s = null;
					var p = 1;
					var t = parseInt(((+new Date()) - this.bakingStartTime) / 100);
					if(t < 30){
						s = "まだ生だった…。";
						p = 0.25;
					} else if(t < 60){
						s = "生焼けだった…。";
						p = 0.50;
					} else if(t < 80){
						s = "火通りが甘い…。";
						p = 0.75;
					} else if(t < 95){
						s = "いい焼け具合だ！";
						p = 1.00;
					} else if(t < 100){
						s = "最高の焼き具合だ！";
						p = 1.25;
					} else if(t < 101){
						s = "完璧な焼き具合だ！";
						p = 1.50;
					} else if(t < 110){
						s = "ちょっとやりすぎた感ただようがいい焦げ方だ！";
						p = 1.00;
					} else if(t < 116){
						s = "焦げ過ぎだった…。";
						p = 0.50;
					} else if(t < 121){
						s = "炭になってる…。";
						p = 0.25;
					} else{
						s = "もはや灰しか残らなかった…。";
						p = 0.00;
					}
					that.basePoint = Math.floor(p * that.basePoint);
					thatManager.userManager.breadList.push(that.basePoint);
					thatManager.addWidget(new MessageWidgetClass(thatManager, [s + "\n" + that.basePoint + "ポイントのパンをゲットした。\n"]));
					that.isSelecting = false;
					that.isBaking = false;
					this.bakingCount = 0;
					this.image = this.imgs[0];
					that.cookSound.pause();
				}
			}
			if(!this.ownerStage.manager.UIManager.keyState.select) this.selectKeyPushed = false;
		}
		if(this.isBaking){
			//焼き途中
			this.bakingTickCount++;
			if(this.bakingTickCount >= 6){
				this.bakingTickCount = 0;
				this.bakingCount++;
				this.image = this.imgs[(this.bakingCount & 1) + 1];
			}
		}
	},
	calculateBreadBasePoint: function(ingr){
		var p = 0;
		for(var i = 0, m = ingr.length; i < m; i++){
			p += IngredientAttributeList[ingr[i].index][1];
		}
		return p;
	},
	draw : function(x, y)
	{
		BakingOvenObjectClass.base.prototype.draw.apply(this, [x, y]);
		this.touchingDirection = 0;
		if(this.bakingCount > 80)
		{
			var puff = (((+new Date()) - this.bakingStartTime) / 100) - 80;
			if(puff > 40)puff = 40;
			if(puff < 0) puff = 0;
			var opacity = (puff / 40);
			this.ownerStage.mainContext.save();
			this.ownerStage.mainContext.globalAlpha = opacity;
			this.ownerStage.mainContext.drawImage(this.img_puff[this.ownerStage.manager.tickCount % 20 < 10 ? 0 : 1], x - 32 , y - 400, 320, 480);
			this.ownerStage.mainContext.restore();
		}
	}
});