<?php
//FOR DEBUG
mysqli_report(MYSQLI_REPORT_ERROR);

require("header.php");
//将来的にURLのname属性は、sqlに渡すため、エスケープして安全を確保しなければいけない。
//->すでにやった
//->escapeMySQLArgumentString
// http://blog.image-lab.net/2012/07/phpmysql.html
// 接続(DB選択含む)
//DB:
//create table AuthUserTable ( id int auto_increment, name char(32), index(id));
//insert into AuthUserTable (name) values ('hikarupsp');
// 実行
//$query = "SELECT * FROM AuthUserTable";
//$stmt = $db->prepare($query);
//$stmt->execute();
// 変数のバインド
//$stmt->bind_result($name,$id);
//while ($stmt->fetch()) {
//	echo $name;
//	echo $id;
//}

$db = new mysqli('localhost', DATABASE_USER, DATABASE_PWD, DATABASE_NAME);
if (mysqli_connect_error()) {
	responseError();
}
// 文字化け防止
$db->set_charset("utf8");
	
if(isset($_GET['action'])){
	$action = $_GET['action'];
	if(isset($_GET['name'])){
		$name = urldecode($_GET['name']);
		escapeMySQLArgumentString($name);
		
		if(strcmp($action, 'join') == 0){
			//通常モード
			$stmt = $db->prepare(QUERY_SELECT_USER_ID);
			$stmt->bind_param(QUERY_SELECT_USER_ID_TYPES, $name);
			$stmt->execute();
			if($stmt->errno == 0){
				//クエリ成功
				$stmt->store_result();
				// 結果の個数を確認
				if($stmt->num_rows == 0){
					//ユーザー名はリストになかった=はじめてのひと
					$stmt = $db->prepare(QUERY_ADD_USER);
					$stgName = DEFAULT_START_STAGE;
					$stmt->bind_param(QUERY_ADD_USER_TYPES, $name, $stgName);
					$stmt->execute();
					if($stmt->errno == 0){
						//クエリ成功
						$stmt = $db->prepare(QUERY_SELECT_USER_ID);
						$stmt->bind_param(QUERY_SELECT_USER_ID_TYPES, $name);
						$stmt->execute();
						if($stmt->errno == 0){
							//クエリ成功
							$stmt->store_result();
							if($stmt->num_rows == 0){
								//ユーザー名はリストになかった=そんな…登録したのに。あきらめてエラーを返す
								responseError();
							} else{
								//ユーザー名がリストにある=予想通り
								$stmt->bind_result($id);
								$stmt->fetch();
								responseNewUser($db, $id);
							}
						} else{
							//クエリ失敗
							responseError();
						}
					} else{
						//クエリ失敗
						responseError();
					}
				} else{
					//すでにユーザー名がリストにある=続きからプレイ
					$stmt->bind_result($id);
					$stmt->fetch();
					$stgName = getUserStage($db, $id);
					responseExistUser($db, $id, $stgName);
				}
			} else{
				//クエリ失敗
				responseError();
			}
		} else if(strcmp($action, 'devjoin') == 0){
			//開発者モード
			if(!isset($_GET['stage'])){
				responseError();
			}
			$stgName = urldecode($_GET['stage']);
			$stmt = $db->prepare(QUERY_SELECT_USER_ID);
			$stmt->bind_param(QUERY_SELECT_USER_ID_TYPES, $name);
			$stmt->execute();
			if($stmt->errno == 0){
				//クエリ成功
				$stmt->store_result();
				// 結果の個数を確認
				if($stmt->num_rows == 0){
					//ユーザー名はリストになかった=はじめてのひと
					$stmt = $db->prepare(QUERY_ADD_USER);
					//$stgName = DEFAULT_START_STAGE;
					$stmt->bind_param(QUERY_ADD_USER_TYPES, $name, $stgName);
					$stmt->execute();
					if($stmt->errno == 0){
						//クエリ成功
						$stmt = $db->prepare(QUERY_SELECT_USER_ID);
						$stmt->bind_param(QUERY_SELECT_USER_ID_TYPES, $name);
						$stmt->execute();
						if($stmt->errno == 0){
							//クエリ成功
							$stmt->store_result();
							if($stmt->num_rows == 0){
								//ユーザー名はリストになかった=そんな…登録したのに。あきらめてエラーを返す
								responseError();
							} else{
								//ユーザー名がリストにある=予想通り
								$stmt->bind_result($id);
								$stmt->fetch();
								responseExistUser($db, $id, getUserStage($db, $id));
							}
						} else{
							//クエリ失敗
							responseError();
						}
					} else{
						//クエリ失敗
						responseError();
					}
				} else{
					//すでにユーザー名がリストにある=続きからプレイ
					$stmt->bind_result($id);
					$stmt->fetch();
					//未実装（本当はデータベースから続きのステージ名を取得するべき）
					updateUserStage($db, $id, $stgName);
					responseExistUser($db, $id, $stgName);
				}
			}
		} else if(strcmp($action, 'chstg') == 0){
			//ステージ移動
			if(!isset($_GET['id'])){
				exit("eee");
			}
			$id = $_GET['id'];
			//deleteUserStageObjectAll($db, $id);
			updateUserStage($db, $id, $name);
			exit("success");
		} else if(strcmp($action, 'chcharacter') == 0){
			if(!isset($_GET['id'])){
				exit("eee");
			}
			$id = $_GET['id'];
			updateUserCharacterClass($db,$id,$name);
			exit("success");
		}
	}
}
//正しいリクエストであればここに来るはずはない
responseError();


//
// response
//
// [[userID], [timestamp], [stageName], [info]];
// info == 10: エラーなし。ログインできる。
// info == 0:データベース通信エラー。ログインできない。
// info == 11: すでにユーザーがログインしている。ログインできない。

function responseError()
{
	exit("[0, 0, \"\", 0];");
}

function responseNewUser($db, $userID)
{
	updateUserTimestamp($db, $userID);
	updateUserStage($db, $userID, DEFAULT_START_STAGE);
	exit("[" . $userID . "," . getTimeStampMs() . ",\"" . DEFAULT_START_STAGE . "\", 10, null]");
}

function responseExistUser($db, $userID, $stageName)
{
	$ts = getUserLastResponseTimestamp($db, $userID);
	$ts -= getTimeStampMs();
	if(-$ts < USER_ALIVE_TIME_MS){
		// info == 11: すでにユーザーがログインしている。ログインできない。
		exit("[" . $userID . "," . getTimeStampMs() . ",\"" . $stageName . "\", 11, \"" . getUserCharacterClass($db, $userID) . "\"];");
	}
	deleteUserStageObjectAll($db, $userID);
	updateUserTimestamp($db, $userID);
	exit("[" . $userID . "," . getTimeStampMs() . ",\"" . $stageName . "\", 10, \"" . getUserCharacterClass($db, $userID) . "\"]");
}

//
// update
//

function updateUserStage($db, $userID, $stageName)
{
	$stmt = $db->prepare(QUERY_UPDATE_USER_STAGE);
	$stmt->bind_param(QUERY_UPDATE_USER_STAGE_TYPES, $stageName, $userID);
	$stmt->execute();
	//エラーチェック省略
	if($stmt->errno != 0){
		exit("error573");
	}
	$stmt->close();
}

function getUserStage($db, $userID)
{
	$stgName = "unknown";
	$stmt = $db->prepare(QUERY_SELECT_USER_STAGE);
	$stmt->bind_param(QUERY_SELECT_USER_STAGE_TYPES, $userID);
	$stmt->execute();
	if($stmt->errno == 0){
		//クエリ成功
		$stmt->store_result();
		// 結果の個数を確認
		if($stmt->num_rows != 0){
			//結果格納
			$stmt->bind_result($stgName);
			$stmt->fetch();
		}
	}
	$stmt->close();
	return $stgName;
}

function updateUserCharacterClass($db, $userID, $className)
{
	$stmt = $db->prepare(QUERY_UPDATE_USER_CCLASS);
	$stmt->bind_param(QUERY_UPDATE_USER_CCLASS_TYPES, $className, $userID);
	$stmt->execute();
	//エラーチェック省略
	if($stmt->errno != 0){
		exit("error573");
	}
	$stmt->close();
}

function getUserCharacterClass($db, $userID)
{
	$className = "unknown";
	$stmt = $db->prepare(QUERY_SELECT_USER_CCLASS);
	$stmt->bind_param(QUERY_SELECT_USER_CCLASS_TYPES, $userID);
	$stmt->execute();
	if($stmt->errno == 0){
		//クエリ成功
		$stmt->store_result();
		// 結果の個数を確認
		if($stmt->num_rows != 0){
			//結果格納
			$stmt->bind_result($className);
			$stmt->fetch();
		}
	}
	$stmt->close();
	return $className;
}

function deleteUserStageObjectAll($db, $userID)
{
	$stmt = $db->prepare(QUERY_DELETE_USER_OBJECT_ALL);
	$stmt->bind_param(QUERY_DELETE_USER_OBJECT_ALL_TYPES, $userID);
	$stmt->execute();
	//エラーチェック省略
}

//
// add
//



?>