#pragma once

#include "resource.h"
#include <Shlwapi.h>
#include <string>


const int32_t k_worldWidth = 16384;	//!<@brief Q[E̕
const int32_t k_worldHeight = 8192;	//!<@brief Q[E̍



inline std::wstring g_makeFullPath(const std::wstring& fileName)
{
	wchar_t filePath[MAX_PATH] = { 0 };

	if (::PathIsRelative(fileName.c_str())) {
		wchar_t dir[MAX_PATH] = { 0 };
		::GetModuleFileName(::GetModuleHandle(NULL), dir, _countof(dir));
		::PathRemoveFileSpec(dir);
		::PathCombine(filePath, dir, fileName.c_str());
	}
	else {
		::lstrcpy(filePath, fileName.c_str());
	}
	return filePath;
}

inline double g_degreeFromRadian( const double radian )
{
	return radian * (180.0 / M_PI);
}

inline double g_radianFromDegree( const double degree )
{
	return degree * (M_PI / 180.0);
}

inline int64_t g_queryPerformanceCounter()
{
	int64_t v = 0;
	::QueryPerformanceCounter( (LARGE_INTEGER *)&v );
	return v;
}

inline int64_t g_queryPerformanceFrequency()
{
	int64_t v = 0;
	::QueryPerformanceFrequency( (LARGE_INTEGER *)&v );
	return v;
}
