#pragma once
#include <list>
#include "GVOImage.h"
#include "GVOShip.h"
#include "GVOConfig.h"




//!@brief En}
//!@brief \WnƐEWn̕ϊȂǂdB
class GVOWorldMap {
public:
private:
	//typedef std::list<POINT> ShipRouteType;
	GVOWorldMap( const GVOWorldMap& );
	GVOWorldMap& operator=(const GVOWorldMap&);

private:
	GVOImage m_mapImage;
	GVOImage m_reducedMapImageCache;	//!<@brief k摜LbV
	POINT m_focusPointInWorldCoord;
	SIZE m_viewSize;

	double m_viewScale;
	double m_ratioForImageCoordFromWorldCoord;	//!<@brief EWn摜Wnւ̕ϊ䗦

	POINT m_shipPointInWorld;			//!<@brief D̈ʒu
	bool m_positionUpdated;				//!<@brief D̈ʒuXV
	POINT m_previousDrawPointInWorld;	//!<@brief O̕`ʒu
	bool m_linkRoute;					//!<@brief qHqĕ`悷tO
	bool m_shipVectorLineEnabled;		//!<@brief jH`tO

public:
	GVOWorldMap() :
		m_viewScale( 1.0 ),
		m_ratioForImageCoordFromWorldCoord(),
		m_positionUpdated(),
		m_linkRoute(),
		m_shipVectorLineEnabled( true )
	{
	}

	virtual ~GVOWorldMap()
	{

	}

	bool loadFromFile( const GVOConfig& config );
	void setViewSize( const SIZE& viewSize );
	//!@note hbOp
	void offsetFocusInViewCoord( const POINT& offset );

	//!@brief ݒŏ
	void setConfig( const GVOConfig& config );

	//!@brief D̈ʒuݒ肷
	void setShipPosition( const POINT& worldCoord, bool isSyncCenter );

	bool zoomIn();
	bool zoomOut();
	inline double viewScale() const
	{
		return m_viewScale;
	}
	inline double viewScaleOrder() const
	{
		return 100;
	}

	//!@note Ƃ肠`炵ĂB
	void drawMap( HDC hdc, const GVOShip& ship );
	void updateShipRouteMap( HDC hdc );
	void clearShipRoute();

	void setVisibleShipRoute( bool visible )
	{
		m_shipVectorLineEnabled = visible;
	}
private:
	inline POINT viewCenterPoint() const
	{
		POINT p = {
			m_viewSize.cx / 2,
			m_viewSize.cy / 2
		};
		return p;
	}
	inline SIZE scaledMapSize() const
	{
		SIZE size = {
			LONG( m_mapImage.width() * m_viewScale ),
			LONG( m_mapImage.height() * m_viewScale )
		};
		return size;
	}
	POINT mapOriginInView();
	POINT imageCoordFromWorldCoord( const POINT& worldCoord ) const;
	POINT drawOffsetFromWorldCoord( const POINT&worldCoord ) const;
};
